/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering.fluid;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.TransparentBlock;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.color.world.BiomeColors;
import net.minecraft.client.render.VertexConsumer;
import net.minecraft.client.render.block.FluidRenderer;
import net.minecraft.client.texture.Sprite;
import net.minecraft.client.texture.SpriteAtlasTexture;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.screen.PlayerScreenHandler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BlockRenderView;

@Environment(value=EnvType.CLIENT)
public class FluidRenderHandlerRegistryImpl
implements FluidRenderHandlerRegistry {
    private static final int DEFAULT_WATER_COLOR = 4159204;
    private final Map<Fluid, FluidRenderHandler> handlers = new IdentityHashMap<Fluid, FluidRenderHandler>();
    private final Map<Fluid, FluidRenderHandler> modHandlers = new IdentityHashMap<Fluid, FluidRenderHandler>();
    private final Map<Block, Boolean> overlayBlocks = new IdentityHashMap<Block, Boolean>();
    private FluidRenderer fluidRenderer;

    @Override
    public FluidRenderHandler get(Fluid fluid) {
        return this.handlers.get(fluid);
    }

    public FluidRenderHandler getOverride(Fluid fluid) {
        return this.modHandlers.get(fluid);
    }

    @Override
    public void register(Fluid fluid, FluidRenderHandler renderer) {
        this.handlers.put(fluid, renderer);
        this.modHandlers.put(fluid, renderer);
    }

    @Override
    public void setBlockTransparency(Block block, boolean transparent) {
        this.overlayBlocks.put(block, transparent);
    }

    @Override
    public boolean isBlockTransparent(Block block) {
        return this.overlayBlocks.computeIfAbsent(block, k -> k instanceof TransparentBlock || k instanceof LeavesBlock);
    }

    public void onFluidRendererReload(FluidRenderer renderer, Sprite[] waterSprites, final Sprite[] lavaSprites, Sprite waterOverlay) {
        this.fluidRenderer = renderer;
        final Sprite[] waterSpritesFull = new Sprite[]{waterSprites[0], waterSprites[1], waterOverlay};
        FluidRenderHandler waterHandler = new FluidRenderHandler(){

            @Override
            public Sprite[] getFluidSprites(BlockRenderView view, BlockPos pos, FluidState state) {
                return waterSpritesFull;
            }

            @Override
            public int getFluidColor(BlockRenderView view, BlockPos pos, FluidState state) {
                if (view != null && pos != null) {
                    return BiomeColors.getWaterColor((BlockRenderView)view, (BlockPos)pos);
                }
                return 4159204;
            }
        };
        FluidRenderHandler lavaHandler = new FluidRenderHandler(){

            @Override
            public Sprite[] getFluidSprites(BlockRenderView view, BlockPos pos, FluidState state) {
                return lavaSprites;
            }
        };
        this.register((Fluid)Fluids.WATER, waterHandler);
        this.register((Fluid)Fluids.FLOWING_WATER, waterHandler);
        this.register((Fluid)Fluids.LAVA, lavaHandler);
        this.register((Fluid)Fluids.FLOWING_LAVA, lavaHandler);
        this.handlers.putAll(this.modHandlers);
        SpriteAtlasTexture texture = MinecraftClient.getInstance().getBakedModelManager().getAtlas(PlayerScreenHandler.BLOCK_ATLAS_TEXTURE);
        for (FluidRenderHandler handler : this.handlers.values()) {
            handler.reloadTextures(texture);
        }
    }

    public void renderFluid(BlockPos pos, BlockRenderView world, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState) {
        this.fluidRenderer.render(world, pos, vertexConsumer, blockState, fluidState);
    }
}

