/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.rendering;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.impl.client.rendering.EntityRendererRegistryImpl;
import net.fabricmc.fabric.impl.client.rendering.RegistrationHelperImpl;
import net.fabricmc.fabric.mixin.client.rendering.LivingEntityRendererAccessor;
import net.minecraft.client.network.AbstractClientPlayerEntity;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.entity.EntityRendererFactory;
import net.minecraft.client.render.entity.EntityRenderers;
import net.minecraft.client.render.entity.LivingEntityRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={EntityRenderers.class})
public abstract class EntityRenderersMixin {
    @Shadow
    @Final
    private static Map<EntityType<?>, EntityRendererFactory<?>> field_27768;

    @Inject(method={"<clinit>*"}, at={@At(value="RETURN")})
    private static void onRegisterRenderers(CallbackInfo info) {
        EntityRendererRegistryImpl.setup((t, factory) -> field_27768.put((EntityType<?>)t, (EntityRendererFactory<?>)factory));
    }

    @Redirect(method={"method_32174"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/EntityRendererFactory;create(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;)Lnet/minecraft/client/render/entity/EntityRenderer;"))
    private static EntityRenderer<?> createEntityRenderer(EntityRendererFactory<?> entityRendererFactory, EntityRendererFactory.Context context, ImmutableMap.Builder builder, EntityRendererFactory.Context context2, EntityType<?> entityType) {
        EntityRenderer entityRenderer = entityRendererFactory.create(context);
        if (entityRenderer instanceof LivingEntityRenderer) {
            LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)entityRenderer;
            ((LivingEntityFeatureRendererRegistrationCallback)LivingEntityFeatureRendererRegistrationCallback.EVENT.invoker()).registerRenderers(entityType, (LivingEntityRenderer)entityRenderer, new RegistrationHelperImpl(accessor::callAddFeature), context);
        }
        return entityRenderer;
    }

    @Redirect(method={"method_32175"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/EntityRendererFactory;create(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;)Lnet/minecraft/client/render/entity/EntityRenderer;"))
    private static EntityRenderer<? extends PlayerEntity> createPlayerEntityRenderer(EntityRendererFactory<AbstractClientPlayerEntity> playerEntityRendererFactory, EntityRendererFactory.Context context, ImmutableMap.Builder builder, EntityRendererFactory.Context context2, String str, EntityRendererFactory<AbstractClientPlayerEntity> playerEntityRendererFactory2) {
        EntityRenderer entityRenderer = playerEntityRendererFactory.create(context);
        LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)entityRenderer;
        ((LivingEntityFeatureRendererRegistrationCallback)LivingEntityFeatureRendererRegistrationCallback.EVENT.invoker()).registerRenderers((EntityType<? extends LivingEntity>)EntityType.PLAYER, (LivingEntityRenderer)entityRenderer, new RegistrationHelperImpl(accessor::callAddFeature), context);
        return entityRenderer;
    }
}

