/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.mixin.client.rendering.DimensionEffectsAccessor;
import net.minecraft.client.render.DimensionEffects;
import net.minecraft.registry.RegistryKey;
import net.minecraft.util.Identifier;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class DimensionRenderingRegistryImpl {
    private static final Map<RegistryKey<World>, DimensionRenderingRegistry.SkyRenderer> SKY_RENDERERS = new IdentityHashMap<RegistryKey<World>, DimensionRenderingRegistry.SkyRenderer>();
    private static final Map<RegistryKey<World>, DimensionRenderingRegistry.CloudRenderer> CLOUD_RENDERERS = new IdentityHashMap<RegistryKey<World>, DimensionRenderingRegistry.CloudRenderer>();
    private static final Map<RegistryKey<World>, DimensionRenderingRegistry.WeatherRenderer> WEATHER_RENDERERS = new IdentityHashMap<RegistryKey<World>, DimensionRenderingRegistry.WeatherRenderer>();

    public static void registerSkyRenderer(RegistryKey<World> key, DimensionRenderingRegistry.SkyRenderer renderer) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(renderer);
        SKY_RENDERERS.putIfAbsent(key, renderer);
    }

    public static void registerWeatherRenderer(RegistryKey<World> key, DimensionRenderingRegistry.WeatherRenderer renderer) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(renderer);
        WEATHER_RENDERERS.putIfAbsent(key, renderer);
    }

    public static void registerDimensionEffects(Identifier key, DimensionEffects effects) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(effects);
        DimensionEffectsAccessor.getIdentifierMap().putIfAbsent((Object)key, (Object)effects);
    }

    public static void registerCloudRenderer(RegistryKey<World> key, DimensionRenderingRegistry.CloudRenderer renderer) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(renderer);
        CLOUD_RENDERERS.putIfAbsent(key, renderer);
    }

    @Nullable
    public static DimensionRenderingRegistry.SkyRenderer getSkyRenderer(RegistryKey<World> key) {
        return SKY_RENDERERS.get(key);
    }

    @Nullable
    public static DimensionRenderingRegistry.CloudRenderer getCloudRenderer(RegistryKey<World> key) {
        return CLOUD_RENDERERS.get(key);
    }

    @Nullable
    public static DimensionRenderingRegistry.WeatherRenderer getWeatherRenderer(RegistryKey<World> key) {
        return WEATHER_RENDERERS.get(key);
    }

    @Nullable
    public static DimensionEffects getDimensionEffects(Identifier key) {
        return (DimensionEffects)DimensionEffectsAccessor.getIdentifierMap().get((Object)key);
    }
}

