/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRenderer;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.model.json.ModelTransformationMode;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.registry.Registries;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class BuiltinItemRendererRegistryImpl
implements BuiltinItemRendererRegistry {
    private static final Map<Item, BuiltinItemRendererRegistry.DynamicItemRenderer> RENDERERS = new HashMap<Item, BuiltinItemRendererRegistry.DynamicItemRenderer>();

    @Override
    public void register(Item item, BuiltinItemRenderer renderer) {
        Objects.requireNonNull(renderer, "renderer is null");
        this.register((ItemConvertible)item, (ItemStack stack, ModelTransformationMode mode, MatrixStack matrices, VertexConsumerProvider vertexConsumers, int light, int overlay) -> renderer.render(stack, matrices, vertexConsumers, light, overlay));
    }

    @Override
    public void register(ItemConvertible item, BuiltinItemRenderer renderer) {
        Objects.requireNonNull(item, "item is null");
        this.register(item.asItem(), renderer);
    }

    @Override
    public void register(ItemConvertible item, BuiltinItemRendererRegistry.DynamicItemRenderer renderer) {
        Objects.requireNonNull(item, "item is null");
        Objects.requireNonNull(item.asItem(), "item is null");
        Objects.requireNonNull(renderer, "renderer is null");
        if (RENDERERS.putIfAbsent(item.asItem(), renderer) != null) {
            throw new IllegalArgumentException("Item " + String.valueOf(Registries.ITEM.getId((Object)item.asItem())) + " already has a builtin renderer!");
        }
    }

    @Override
    @Nullable
    public BuiltinItemRendererRegistry.DynamicItemRenderer get(ItemConvertible item) {
        Objects.requireNonNull(item.asItem(), "item is null");
        return RENDERERS.get(item.asItem());
    }
}

