/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.HashMap;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.block.entity.BlockEntityType;
import net.minecraft.client.render.block.entity.BlockEntityRendererFactory;

@Environment(value=EnvType.CLIENT)
public final class BlockEntityRendererRegistryImpl {
    private static final HashMap<BlockEntityType<?>, BlockEntityRendererFactory<?>> MAP = new HashMap();
    private static BiConsumer<BlockEntityType<?>, BlockEntityRendererFactory<?>> handler = (type, function) -> MAP.put((BlockEntityType<?>)type, (BlockEntityRendererFactory<?>)function);

    public static <E extends BlockEntity> void register(BlockEntityType<E> blockEntityType, BlockEntityRendererFactory<? super E> blockEntityRendererFactory) {
        handler.accept(blockEntityType, blockEntityRendererFactory);
    }

    public static void setup(BiConsumer<BlockEntityType<?>, BlockEntityRendererFactory<?>> vanillaHandler) {
        MAP.forEach(vanillaHandler);
        handler = vanillaHandler;
    }

    private BlockEntityRendererRegistryImpl() {
    }
}

