/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.loader;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.impl.resource.loader.FabricLifecycledResourceManager;
import net.fabricmc.fabric.impl.resource.loader.ResourceManagerHelperImpl;
import net.minecraft.resource.ProfiledResourceReload;
import net.minecraft.resource.ResourceManager;
import net.minecraft.resource.ResourceReload;
import net.minecraft.resource.ResourceReloader;
import net.minecraft.resource.ResourceType;
import net.minecraft.resource.SimpleResourceReload;
import net.minecraft.util.Unit;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SimpleResourceReload.class})
public class SimpleResourceReloadMixin {
    @Unique
    private static final ThreadLocal<ResourceType> fabric_resourceType = new ThreadLocal();

    @Inject(method={"start"}, at={@At(value="HEAD")})
    private static void method_40087(ResourceManager resourceManager, List<ResourceReloader> list, Executor executor, Executor executor2, CompletableFuture<Unit> completableFuture, boolean bl, CallbackInfoReturnable<ResourceReload> cir) {
        if (resourceManager instanceof FabricLifecycledResourceManager) {
            FabricLifecycledResourceManager flrm = (FabricLifecycledResourceManager)resourceManager;
            fabric_resourceType.set(flrm.fabric_getResourceType());
        }
    }

    @ModifyArg(method={"start"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/resource/SimpleResourceReload;create(Lnet/minecraft/resource/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;)Lnet/minecraft/resource/SimpleResourceReload;"))
    private static List<ResourceReloader> sortSimple(List<ResourceReloader> reloaders) {
        List<ResourceReloader> sorted = ResourceManagerHelperImpl.sort(fabric_resourceType.get(), reloaders);
        fabric_resourceType.set(null);
        return sorted;
    }

    @Redirect(method={"start"}, at=@At(value="NEW", target="Lnet/minecraft/resource/ProfiledResourceReload;<init>"))
    private static ProfiledResourceReload sortProfiled(ResourceManager manager, List<ResourceReloader> reloaders, Executor prepareExecutor, Executor applyExecutor, CompletableFuture<Unit> initialStage) {
        List<ResourceReloader> sorted = ResourceManagerHelperImpl.sort(fabric_resourceType.get(), reloaders);
        fabric_resourceType.set(null);
        return new ProfiledResourceReload(manager, sorted, prepareExecutor, applyExecutor, initialStage);
    }
}

