/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.gamerule.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.gamerule.v1.CustomGameRuleCategory;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.screen.world.EditGameRulesScreen;
import net.minecraft.client.gui.widget.EntryListWidget;
import net.minecraft.world.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={EditGameRulesScreen.RuleListWidget.class})
public abstract class EditGameRulesScreenRuleListWidgetMixin
extends EntryListWidget<EditGameRulesScreen.AbstractRuleWidget> {
    @Unique
    private final Map<CustomGameRuleCategory, List<EditGameRulesScreen.AbstractRuleWidget>> fabricCategories = new HashMap<CustomGameRuleCategory, List<EditGameRulesScreen.AbstractRuleWidget>>();

    public EditGameRulesScreenRuleListWidgetMixin(MinecraftClient client, int width, int height, int top, int bottom, int itemHeight) {
        super(client, width, height, top, bottom, itemHeight);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/gui/screen/world/EditGameRulesScreen;Lnet/minecraft/world/GameRules;)V"}, at={@At(value="TAIL")})
    private void initializeFabricGameruleCategories(EditGameRulesScreen screen, GameRules gameRules, CallbackInfo ci) {
        this.fabricCategories.forEach((category, widgetList) -> {
            EditGameRulesScreen editGameRulesScreen = screen;
            Objects.requireNonNull(editGameRulesScreen);
            this.addEntry((EntryListWidget.Entry)new EditGameRulesScreen.RuleCategoryWidget(editGameRulesScreen, category.getName()));
            for (EditGameRulesScreen.AbstractRuleWidget widget : widgetList) {
                this.addEntry((EntryListWidget.Entry)widget);
            }
        });
    }

    @Inject(method={"method_27638(Ljava/util/Map$Entry;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void ignoreKeysWithCustomCategories(Map.Entry<GameRules.Key<?>, EditGameRulesScreen.AbstractRuleWidget> entry, CallbackInfo ci) {
        GameRules.Key<?> ruleKey = entry.getKey();
        CustomGameRuleCategory.getCategory(ruleKey).ifPresent(key -> {
            this.fabricCategories.computeIfAbsent((CustomGameRuleCategory)key, c -> new ArrayList()).add((EditGameRulesScreen.AbstractRuleWidget)entry.getValue());
            ci.cancel();
        });
    }
}

