/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.gamerule.rule;

import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.mixin.gamerule.GameRulesIntRuleAccessor;
import net.minecraft.world.GameRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoundedIntRule
extends GameRules.IntRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(GameRuleRegistry.class);
    private final int minimumValue;
    private final int maximumValue;

    public BoundedIntRule(GameRules.Type<GameRules.IntRule> type, int initialValue, int minimumValue, int maximumValue) {
        super(type, initialValue);
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
    }

    protected void deserialize(String value) {
        int i = BoundedIntRule.parseInt(value);
        if (this.minimumValue > i || this.maximumValue < i) {
            LOGGER.warn("Failed to parse integer {}. Was out of bounds {} - {}", new Object[]{value, this.minimumValue, this.maximumValue});
            return;
        }
        ((GameRulesIntRuleAccessor)((Object)this)).setValue(i);
    }

    public boolean validate(String input) {
        try {
            int value = Integer.parseInt(input);
            if (this.minimumValue > value || this.maximumValue < value) {
                return false;
            }
            ((GameRulesIntRuleAccessor)((Object)this)).setValue(value);
            return true;
        }
        catch (NumberFormatException var3) {
            return false;
        }
    }

    protected GameRules.IntRule copy() {
        return new BoundedIntRule((GameRules.Type<GameRules.IntRule>)this.type, ((GameRulesIntRuleAccessor)((Object)this)).getValue(), this.minimumValue, this.maximumValue);
    }

    private static int parseInt(String input) {
        if (!input.isEmpty()) {
            try {
                return Integer.parseInt(input);
            }
            catch (NumberFormatException var2) {
                LOGGER.warn("Failed to parse integer {}", (Object)input);
            }
        }
        return 0;
    }
}

