/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.gamerule.v1.rule;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.world.GameRules;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnumRule<E extends Enum<E>>
extends GameRules.Rule<EnumRule<E>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GameRuleRegistry.class);
    private final Class<E> classType;
    private final List<E> supportedValues;
    private E value;

    @Deprecated
    public EnumRule(GameRules.Type<EnumRule<E>> type, E value, E[] supportedValues) {
        this(type, value, Arrays.asList(supportedValues));
    }

    @Deprecated
    public EnumRule(GameRules.Type<EnumRule<E>> type, E value, Collection<E> supportedValues) {
        super(type);
        this.classType = ((Enum)value).getDeclaringClass();
        this.value = value;
        this.supportedValues = new ArrayList<E>(supportedValues);
        if (!this.supports(value)) {
            throw new IllegalArgumentException("Cannot set default value");
        }
    }

    protected void setFromArgument(CommandContext<ServerCommandSource> context, String name) {
    }

    protected void deserialize(String value) {
        try {
            E deserialized = Enum.valueOf(this.classType, value);
            if (!this.supports(deserialized)) {
                LOGGER.warn("Failed to parse rule of value {} for rule of type {}. Since the value {}, is unsupported.", new Object[]{value, this.classType, value});
            }
            this.set(deserialized, null);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Failed to parse rule of value {} for rule of type {}", (Object)value, this.classType);
        }
    }

    public String serialize() {
        return ((Enum)this.value).name();
    }

    public int getCommandResult() {
        return ((Enum)this.value).ordinal();
    }

    protected EnumRule<E> getThis() {
        return this;
    }

    public Class<E> getEnumClass() {
        return this.classType;
    }

    public String toString() {
        return ((Enum)this.value).toString();
    }

    protected EnumRule<E> copy() {
        return new EnumRule<E>(this.type, this.value, this.supportedValues);
    }

    public void setValue(EnumRule<E> rule, MinecraftServer minecraftServer) {
        if (!this.supports(rule.value)) {
            throw new IllegalArgumentException(String.format("Rule does not support value: %s", rule.value));
        }
        this.value = rule.value;
        this.changed(minecraftServer);
    }

    public E get() {
        return this.value;
    }

    public void cycle() {
        int index = this.supportedValues.indexOf(this.value);
        if (index < 0) {
            throw new IllegalArgumentException(String.format("Invalid value: %s", this.value));
        }
        this.set((Enum)this.supportedValues.get((index + 1) % this.supportedValues.size()), null);
    }

    public boolean supports(E value) {
        return this.supportedValues.contains(value);
    }

    public void set(E value, @Nullable MinecraftServer server) throws IllegalArgumentException {
        Preconditions.checkNotNull(value);
        if (!this.supports(value)) {
            throw new IllegalArgumentException("Tried to set an unsupported value: " + ((Enum)value).toString());
        }
        this.value = value;
        this.changed(server);
    }
}

