/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.container;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.ContainerScreenFactory;
import net.fabricmc.fabric.api.client.screen.ScreenProviderRegistry;
import net.fabricmc.fabric.api.container.ContainerFactory;
import net.fabricmc.fabric.api.container.ContainerProviderRegistry;
import net.fabricmc.fabric.impl.container.ContainerProviderImpl;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.ingame.HandledScreen;
import net.minecraft.client.network.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.screen.ScreenHandler;
import net.minecraft.util.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ScreenProviderRegistryImpl
implements ScreenProviderRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScreenProviderRegistryImpl.class);
    private static final Map<Identifier, ContainerFactory<HandledScreen>> FACTORIES = new HashMap<Identifier, ContainerFactory<HandledScreen>>();

    @Override
    public void registerFactory(Identifier identifier, ContainerFactory<HandledScreen> factory) {
        if (FACTORIES.containsKey(identifier)) {
            throw new RuntimeException("A factory has already been registered as " + String.valueOf(identifier) + "!");
        }
        FACTORIES.put(identifier, factory);
    }

    @Override
    public <C extends ScreenHandler> void registerFactory(Identifier identifier, ContainerScreenFactory<C> containerScreenFactory) {
        this.registerFactory(identifier, (ContainerFactory<HandledScreen>)((ContainerFactory)(syncId, identifier1, player, buf) -> {
            ScreenHandler container = ((ContainerProviderImpl)ContainerProviderRegistry.INSTANCE).createContainer(syncId, identifier1, player, buf);
            if (container == null) {
                LOGGER.error("Could not open container for {} - a null object was created!", (Object)identifier1.toString());
                return null;
            }
            return containerScreenFactory.create(container);
        }));
    }

    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((Identifier)ContainerProviderImpl.OPEN_CONTAINER, (client, handler, buf, responseSender) -> {
            Identifier identifier = buf.readIdentifier();
            short syncId = buf.readUnsignedByte();
            buf.retain();
            client.execute(() -> {
                try {
                    ContainerFactory<HandledScreen> factory = FACTORIES.get(identifier);
                    if (factory == null) {
                        LOGGER.error("No GUI factory found for {}!", (Object)identifier.toString());
                        return;
                    }
                    ClientPlayerEntity player = client.player;
                    HandledScreen gui = (HandledScreen)factory.create(syncId, identifier, (PlayerEntity)player, buf);
                    player.currentScreenHandler = gui.getScreenHandler();
                    client.setScreen((Screen)gui);
                }
                finally {
                    buf.release();
                }
            });
        });
    }
}

