/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.object.builder;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.village.TradeOffers;
import net.minecraft.village.VillagerProfession;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TradeOfferInternals {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-object-builder-api-v1");

    private TradeOfferInternals() {
    }

    public static synchronized void registerVillagerOffers(VillagerProfession profession, int level, Consumer<List<TradeOffers.Factory>> factory) {
        Objects.requireNonNull(profession, "VillagerProfession may not be null.");
        TradeOfferInternals.registerOffers((Int2ObjectMap<TradeOffers.Factory[]>)TradeOffers.PROFESSION_TO_LEVELED_TRADE.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap()), level, factory);
    }

    public static synchronized void registerWanderingTraderOffers(int level, Consumer<List<TradeOffers.Factory>> factory) {
        TradeOfferInternals.registerOffers((Int2ObjectMap<TradeOffers.Factory[]>)TradeOffers.WANDERING_TRADER_TRADES, level, factory);
    }

    private static void registerOffers(Int2ObjectMap<TradeOffers.Factory[]> leveledTradeMap, int level, Consumer<List<TradeOffers.Factory>> factory) {
        ArrayList list = new ArrayList();
        factory.accept(list);
        Object[] originalEntries = (TradeOffers.Factory[])leveledTradeMap.computeIfAbsent(level, key -> new TradeOffers.Factory[0]);
        Object[] addedEntries = list.toArray(new TradeOffers.Factory[0]);
        TradeOffers.Factory[] allEntries = (TradeOffers.Factory[])ArrayUtils.addAll((Object[])originalEntries, (Object[])addedEntries);
        leveledTradeMap.put(level, (Object)allEntries);
    }

    public static void printRefreshOffersWarning() {
        Throwable loggingThrowable = new Throwable();
        LOGGER.warn("TradeOfferHelper#refreshOffers does not do anything, yet it was called! Stack trace:", loggingThrowable);
    }
}

