/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.tag.client.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.tag.client.ClientTagsImpl;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.registry.tag.TagKey;
import net.minecraft.util.Identifier;

@Environment(value=EnvType.CLIENT)
public final class ClientTags {
    private ClientTags() {
    }

    public static Set<Identifier> getOrCreateLocalTag(TagKey<?> tagKey) {
        return ClientTagsImpl.getOrCreatePartiallySyncedTag(tagKey).completeIds();
    }

    public static <T> boolean isInWithLocalFallback(TagKey<T> tagKey, T entry) {
        Objects.requireNonNull(tagKey);
        Objects.requireNonNull(entry);
        return ClientTagsImpl.getRegistryEntry(tagKey, entry).map(re -> ClientTags.isInWithLocalFallback(tagKey, re)).orElse(false);
    }

    public static <T> boolean isInWithLocalFallback(TagKey<T> tagKey, RegistryEntry<T> registryEntry) {
        Objects.requireNonNull(tagKey);
        Objects.requireNonNull(registryEntry);
        return ClientTagsImpl.isInWithLocalFallback(tagKey, registryEntry);
    }

    public static <T> boolean isInLocal(TagKey<T> tagKey, RegistryKey<T> registryKey) {
        Objects.requireNonNull(tagKey);
        Objects.requireNonNull(registryKey);
        if (tagKey.registry().getValue().equals((Object)registryKey.getRegistry())) {
            Set<Identifier> ids = ClientTags.getOrCreateLocalTag(tagKey);
            return ids.contains(registryKey.getValue());
        }
        return false;
    }
}

