/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.datagen.loot;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLootTableProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.data.DataOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.DataWriter;
import net.minecraft.loot.LootDataType;
import net.minecraft.loot.context.LootContextType;
import net.minecraft.util.Identifier;

public final class FabricLootTableProviderImpl {
    public static CompletableFuture<?> run(DataWriter writer, FabricLootTableProvider provider, LootContextType lootContextType, FabricDataOutput fabricDataOutput) {
        HashMap builders = Maps.newHashMap();
        HashMap conditionMap = new HashMap();
        provider.accept((identifier, builder) -> {
            ConditionJsonProvider[] conditions = FabricDataGenHelper.consumeConditions(builder);
            conditionMap.put(identifier, conditions);
            if (builders.put(identifier, builder.type(lootContextType).build()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(identifier));
            }
        });
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Map.Entry entry : builders.entrySet()) {
            JsonObject tableJson = (JsonObject)LootDataType.LOOT_TABLES.getGson().toJsonTree(entry.getValue());
            ConditionJsonProvider.write((JsonObject)tableJson, (ConditionJsonProvider[])((ConditionJsonProvider[])conditionMap.remove(entry.getKey())));
            futures.add(DataProvider.writeToPath((DataWriter)writer, (JsonElement)tableJson, (Path)FabricLootTableProviderImpl.getOutputPath(fabricDataOutput, (Identifier)entry.getKey())));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private static Path getOutputPath(FabricDataOutput dataOutput, Identifier lootTableId) {
        return dataOutput.getResolver(DataOutput.OutputType.DATA_PACK, "loot_tables").resolveJson(lootTableId);
    }

    private FabricLootTableProviderImpl() {
    }
}

