/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.impl.datagen.ForcedTagEntry;
import net.minecraft.block.Block;
import net.minecraft.data.DataOutput;
import net.minecraft.data.server.tag.TagProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.RegistryWrapper;
import net.minecraft.registry.tag.TagBuilder;
import net.minecraft.registry.tag.TagEntry;
import net.minecraft.registry.tag.TagKey;
import net.minecraft.util.Identifier;
import net.minecraft.world.event.GameEvent;
import org.jetbrains.annotations.Nullable;

public abstract class FabricTagProvider<T>
extends TagProvider<T> {
    public FabricTagProvider(FabricDataOutput output, RegistryKey<? extends Registry<T>> registryKey, CompletableFuture<RegistryWrapper.WrapperLookup> registriesFuture) {
        super((DataOutput)output, registryKey, registriesFuture);
    }

    protected abstract void configure(RegistryWrapper.WrapperLookup var1);

    protected RegistryKey<T> reverseLookup(T element) {
        Optional key;
        Registry registry = (Registry)Registries.REGISTRIES.get(this.registryRef);
        if (registry != null && (key = registry.getKey(element)).isPresent()) {
            return (RegistryKey)key.get();
        }
        throw new UnsupportedOperationException("Adding objects is not supported by " + String.valueOf(((Object)((Object)this)).getClass()));
    }

    protected FabricTagBuilder getOrCreateTagBuilder(TagKey<T> tag) {
        return new FabricTagBuilder(super.getOrCreateTagBuilder(tag));
    }

    public final class FabricTagBuilder
    extends TagProvider.ProvidedTagBuilder<T> {
        private final TagProvider.ProvidedTagBuilder<T> parent;

        private FabricTagBuilder(TagProvider.ProvidedTagBuilder<T> parent) {
            super(parent.builder);
            this.parent = parent;
        }

        public FabricTagBuilder setReplace(boolean replace) {
            ((net.fabricmc.fabric.impl.datagen.FabricTagBuilder)this.builder).fabric_setReplace(replace);
            return this;
        }

        public FabricTagBuilder add(T element) {
            this.add(FabricTagProvider.this.reverseLookup(element));
            return this;
        }

        @SafeVarargs
        public final FabricTagBuilder add(T ... element) {
            Stream.of(element).map(FabricTagProvider.this::reverseLookup).forEach(registryKey -> this.add((RegistryKey)registryKey));
            return this;
        }

        public FabricTagBuilder add(RegistryKey<T> registryKey) {
            this.parent.add(registryKey);
            return this;
        }

        public FabricTagBuilder add(Identifier id) {
            this.builder.add(id);
            return this;
        }

        public FabricTagBuilder addOptional(Identifier id) {
            this.parent.addOptional(id);
            return this;
        }

        public FabricTagBuilder addOptional(RegistryKey<? extends T> registryKey) {
            return this.addOptional(registryKey.getValue());
        }

        public FabricTagBuilder addTag(TagKey<T> tag) {
            this.builder.addTag(tag.id());
            return this;
        }

        public FabricTagBuilder addOptionalTag(Identifier id) {
            this.parent.addOptionalTag(id);
            return this;
        }

        public FabricTagBuilder addOptionalTag(TagKey<T> tag) {
            return this.addOptionalTag(tag.id());
        }

        public FabricTagBuilder forceAddTag(TagKey<T> tag) {
            this.builder.add((TagEntry)new ForcedTagEntry(TagEntry.create((Identifier)tag.id())));
            return this;
        }

        public FabricTagBuilder add(Identifier ... ids) {
            for (Identifier id : ids) {
                this.add(id);
            }
            return this;
        }

        @SafeVarargs
        public final FabricTagBuilder add(RegistryKey<T> ... registryKeys) {
            for (RegistryKey registryKey : registryKeys) {
                this.add(registryKey);
            }
            return this;
        }
    }

    public static abstract class GameEventTagProvider
    extends FabricTagProvider<GameEvent> {
        public GameEventTagProvider(FabricDataOutput output, CompletableFuture<RegistryWrapper.WrapperLookup> completableFuture) {
            super(output, RegistryKeys.GAME_EVENT, completableFuture);
        }

        @Override
        protected RegistryKey<GameEvent> reverseLookup(GameEvent element) {
            return element.getRegistryEntry().registryKey();
        }
    }

    public static abstract class EntityTypeTagProvider
    extends FabricTagProvider<EntityType<?>> {
        public EntityTypeTagProvider(FabricDataOutput output, CompletableFuture<RegistryWrapper.WrapperLookup> completableFuture) {
            super(output, RegistryKeys.ENTITY_TYPE, completableFuture);
        }

        @Override
        protected RegistryKey<EntityType<?>> reverseLookup(EntityType<?> element) {
            return element.getRegistryEntry().registryKey();
        }
    }

    public static abstract class EnchantmentTagProvider
    extends FabricTagProvider<Enchantment> {
        public EnchantmentTagProvider(FabricDataOutput output, CompletableFuture<RegistryWrapper.WrapperLookup> completableFuture) {
            super(output, RegistryKeys.ENCHANTMENT, completableFuture);
        }

        @Override
        protected RegistryKey<Enchantment> reverseLookup(Enchantment element) {
            return (RegistryKey)Registries.ENCHANTMENT.getKey((Object)element).orElseThrow(() -> new IllegalArgumentException("Enchantment " + String.valueOf(element) + " is not registered"));
        }
    }

    public static abstract class FluidTagProvider
    extends FabricTagProvider<Fluid> {
        public FluidTagProvider(FabricDataOutput output, CompletableFuture<RegistryWrapper.WrapperLookup> completableFuture) {
            super(output, RegistryKeys.FLUID, completableFuture);
        }

        @Override
        protected RegistryKey<Fluid> reverseLookup(Fluid element) {
            return element.getRegistryEntry().registryKey();
        }
    }

    public static abstract class ItemTagProvider
    extends FabricTagProvider<Item> {
        @Nullable
        private final Function<TagKey<Block>, TagBuilder> blockTagBuilderProvider;

        public ItemTagProvider(FabricDataOutput output, CompletableFuture<RegistryWrapper.WrapperLookup> completableFuture, @Nullable BlockTagProvider blockTagProvider) {
            super(output, RegistryKeys.ITEM, completableFuture);
            this.blockTagBuilderProvider = blockTagProvider == null ? null : x$0 -> ((FabricTagProvider)blockTagProvider).getTagBuilder(x$0);
        }

        public ItemTagProvider(FabricDataOutput output, CompletableFuture<RegistryWrapper.WrapperLookup> completableFuture) {
            this(output, completableFuture, null);
        }

        public void copy(TagKey<Block> blockTag, TagKey<Item> itemTag) {
            TagBuilder blockTagBuilder = Objects.requireNonNull(this.blockTagBuilderProvider, "Pass Block tag provider via constructor to use copy").apply(blockTag);
            TagBuilder itemTagBuilder = this.getTagBuilder(itemTag);
            blockTagBuilder.build().forEach(arg_0 -> ((TagBuilder)itemTagBuilder).add(arg_0));
        }

        @Override
        protected RegistryKey<Item> reverseLookup(Item element) {
            return element.getRegistryEntry().registryKey();
        }
    }

    public static abstract class BlockTagProvider
    extends FabricTagProvider<Block> {
        public BlockTagProvider(FabricDataOutput output, CompletableFuture<RegistryWrapper.WrapperLookup> registriesFuture) {
            super(output, RegistryKeys.BLOCK, registriesFuture);
        }

        @Override
        protected RegistryKey<Block> reverseLookup(Block element) {
            return element.getRegistryEntry().registryKey();
        }
    }
}

