/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLootTableProvider;
import net.fabricmc.fabric.impl.datagen.loot.FabricLootTableProviderImpl;
import net.minecraft.block.Block;
import net.minecraft.data.DataWriter;
import net.minecraft.data.server.loottable.BlockLootTableGenerator;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.context.LootContextTypes;
import net.minecraft.registry.Registries;
import net.minecraft.resource.featuretoggle.FeatureFlags;
import net.minecraft.util.Identifier;

public abstract class FabricBlockLootTableProvider
extends BlockLootTableGenerator
implements FabricLootTableProvider {
    private final FabricDataOutput output;
    private final Set<Identifier> excludedFromStrictValidation = new HashSet<Identifier>();

    protected FabricBlockLootTableProvider(FabricDataOutput dataOutput) {
        super(Collections.emptySet(), FeatureFlags.FEATURE_MANAGER.getFeatureSet());
        this.output = dataOutput;
    }

    public abstract void generate();

    public void excludeFromStrictValidation(Block block) {
        this.excludedFromStrictValidation.add(Registries.BLOCK.getId((Object)block));
    }

    public void accept(BiConsumer<Identifier, LootTable.Builder> biConsumer) {
        this.generate();
        for (Map.Entry entry : this.lootTables.entrySet()) {
            Identifier identifier = (Identifier)entry.getKey();
            if (identifier.equals((Object)LootTables.EMPTY)) continue;
            biConsumer.accept(identifier, (LootTable.Builder)entry.getValue());
        }
        if (this.output.isStrictValidationEnabled()) {
            HashSet missing = Sets.newHashSet();
            for (Identifier blockId : Registries.BLOCK.getIds()) {
                Identifier blockLootTableId;
                if (!blockId.getNamespace().equals(this.output.getModId()) || !(blockLootTableId = ((Block)Registries.BLOCK.get(blockId)).getLootTableId()).getNamespace().equals(this.output.getModId()) || this.lootTables.containsKey(blockLootTableId)) continue;
                missing.add(blockId);
            }
            missing.removeAll(this.excludedFromStrictValidation);
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing loot table(s) for %s".formatted(missing));
            }
        }
    }

    public CompletableFuture<?> run(DataWriter writer) {
        return FabricLootTableProviderImpl.run(writer, this, LootContextTypes.BLOCK, this.output);
    }

    public String getName() {
        return "Block Loot Tables";
    }
}

