/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.itemgroup;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroup;
import net.fabricmc.fabric.impl.itemgroup.ItemGroupEventsImpl;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemGroups;
import net.minecraft.item.ItemStack;
import net.minecraft.registry.Registries;
import net.minecraft.registry.RegistryKey;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemGroup.class})
abstract class ItemGroupMixin
implements FabricItemGroup {
    @Shadow
    private Collection<ItemStack> field_40859;
    @Shadow
    private Set<ItemStack> field_40860;
    @Unique
    private int fabric_page = -1;

    ItemGroupMixin() {
    }

    @Inject(method={"updateEntries"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemGroup;reloadSearchProvider()V")})
    public void getStacks(ItemGroup.DisplayContext context, CallbackInfo ci) {
        ItemGroup self = (ItemGroup)this;
        RegistryKey registryKey = (RegistryKey)Registries.ITEM_GROUP.getKey((Object)self).orElseThrow(() -> new IllegalStateException("Unregistered item group : " + String.valueOf(self)));
        if (self.isSpecial() && registryKey != ItemGroups.OPERATOR) {
            return;
        }
        Objects.requireNonNull(this.field_40859, "displayStacks");
        Objects.requireNonNull(this.field_40860, "searchTabStacks");
        LinkedList<ItemStack> mutableDisplayStacks = new LinkedList<ItemStack>(this.field_40859);
        LinkedList<ItemStack> mutableSearchTabStacks = new LinkedList<ItemStack>(this.field_40860);
        FabricItemGroupEntries entries = new FabricItemGroupEntries(context, mutableDisplayStacks, mutableSearchTabStacks);
        Event<ItemGroupEvents.ModifyEntries> modifyEntriesEvent = ItemGroupEventsImpl.getModifyEntriesEvent((RegistryKey<ItemGroup>)registryKey);
        if (modifyEntriesEvent != null) {
            ((ItemGroupEvents.ModifyEntries)modifyEntriesEvent.invoker()).modifyEntries(entries);
        }
        if (registryKey != ItemGroups.OPERATOR || context.hasPermissions()) {
            ((ItemGroupEvents.ModifyEntriesAll)ItemGroupEvents.MODIFY_ENTRIES_ALL.invoker()).modifyEntries(self, entries);
        }
        this.field_40859.clear();
        this.field_40859.addAll(mutableDisplayStacks);
        this.field_40860.clear();
        this.field_40860.addAll(mutableSearchTabStacks);
    }

    @Override
    public int getPage() {
        if (this.fabric_page < 0) {
            throw new IllegalStateException("Item group has no page");
        }
        return this.fabric_page;
    }

    @Override
    public void setPage(int page) {
        this.fabric_page = page;
    }
}

