/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.itemgroup.v1;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.resource.featuretoggle.FeatureSet;
import org.jetbrains.annotations.ApiStatus;

public class FabricItemGroupEntries
implements ItemGroup.Entries {
    private final ItemGroup.DisplayContext context;
    private final List<ItemStack> displayStacks;
    private final List<ItemStack> searchTabStacks;

    @ApiStatus.Internal
    public FabricItemGroupEntries(ItemGroup.DisplayContext context, List<ItemStack> displayStacks, List<ItemStack> searchTabStacks) {
        this.context = context;
        this.displayStacks = displayStacks;
        this.searchTabStacks = searchTabStacks;
    }

    public ItemGroup.DisplayContext getContext() {
        return this.context;
    }

    public FeatureSet getEnabledFeatures() {
        return this.context.enabledFeatures();
    }

    public boolean shouldShowOpRestrictedItems() {
        return this.context.hasPermissions();
    }

    public List<ItemStack> getDisplayStacks() {
        return this.displayStacks;
    }

    public List<ItemStack> getSearchTabStacks() {
        return this.searchTabStacks;
    }

    public void add(ItemStack stack, ItemGroup.StackVisibility visibility) {
        if (this.isEnabled(stack)) {
            FabricItemGroupEntries.checkStack(stack);
            switch (visibility) {
                case PARENT_AND_SEARCH_TABS: {
                    this.displayStacks.add(stack);
                    this.searchTabStacks.add(stack);
                    break;
                }
                case PARENT_TAB_ONLY: {
                    this.displayStacks.add(stack);
                    break;
                }
                case SEARCH_TAB_ONLY: {
                    this.searchTabStacks.add(stack);
                }
            }
        }
    }

    public void prepend(ItemStack stack) {
        this.prepend(stack, ItemGroup.StackVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void prepend(ItemStack stack, ItemGroup.StackVisibility visibility) {
        if (this.isEnabled(stack)) {
            FabricItemGroupEntries.checkStack(stack);
            switch (visibility) {
                case PARENT_AND_SEARCH_TABS: {
                    this.displayStacks.add(0, stack);
                    this.searchTabStacks.add(0, stack);
                    break;
                }
                case PARENT_TAB_ONLY: {
                    this.displayStacks.add(0, stack);
                    break;
                }
                case SEARCH_TAB_ONLY: {
                    this.searchTabStacks.add(0, stack);
                }
            }
        }
    }

    public void prepend(ItemConvertible item) {
        this.prepend(item, ItemGroup.StackVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void prepend(ItemConvertible item, ItemGroup.StackVisibility visibility) {
        this.prepend(new ItemStack(item), visibility);
    }

    public void addAfter(ItemConvertible afterLast, ItemStack ... newStack) {
        this.addAfter(afterLast, Arrays.asList(newStack));
    }

    public void addAfter(ItemStack afterLast, ItemStack ... newStack) {
        this.addAfter(afterLast, Arrays.asList(newStack));
    }

    public void addAfter(ItemConvertible afterLast, ItemConvertible ... newItem) {
        this.addAfter(afterLast, Arrays.stream(newItem).map(ItemStack::new).toList());
    }

    public void addAfter(ItemStack afterLast, ItemConvertible ... newItem) {
        this.addAfter(afterLast, Arrays.stream(newItem).map(ItemStack::new).toList());
    }

    public void addAfter(ItemConvertible afterLast, Collection<ItemStack> newStacks) {
        this.addAfter(afterLast, newStacks, ItemGroup.StackVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void addAfter(ItemStack afterLast, Collection<ItemStack> newStacks) {
        this.addAfter(afterLast, newStacks, ItemGroup.StackVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void addAfter(ItemConvertible afterLast, Collection<ItemStack> newStacks, ItemGroup.StackVisibility visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case PARENT_AND_SEARCH_TABS: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
                break;
            }
            case PARENT_TAB_ONLY: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                break;
            }
            case SEARCH_TAB_ONLY: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addAfter(ItemStack afterLast, Collection<ItemStack> newStacks, ItemGroup.StackVisibility visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case PARENT_AND_SEARCH_TABS: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
                break;
            }
            case PARENT_TAB_ONLY: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                break;
            }
            case SEARCH_TAB_ONLY: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addAfter(Predicate<ItemStack> afterLast, Collection<ItemStack> newStacks, ItemGroup.StackVisibility visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case PARENT_AND_SEARCH_TABS: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
                break;
            }
            case PARENT_TAB_ONLY: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                break;
            }
            case SEARCH_TAB_ONLY: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addBefore(ItemConvertible beforeFirst, ItemStack ... newStack) {
        this.addBefore(beforeFirst, Arrays.asList(newStack));
    }

    public void addBefore(ItemStack beforeFirst, ItemStack ... newStack) {
        this.addBefore(beforeFirst, Arrays.asList(newStack));
    }

    public void addBefore(ItemConvertible beforeFirst, ItemConvertible ... newItem) {
        this.addBefore(beforeFirst, Arrays.stream(newItem).map(ItemStack::new).toList());
    }

    public void addBefore(ItemStack beforeFirst, ItemConvertible ... newItem) {
        this.addBefore(beforeFirst, Arrays.stream(newItem).map(ItemStack::new).toList());
    }

    public void addBefore(ItemConvertible beforeFirst, Collection<ItemStack> newStacks) {
        this.addBefore(beforeFirst, newStacks, ItemGroup.StackVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void addBefore(ItemStack beforeFirst, Collection<ItemStack> newStacks) {
        this.addBefore(beforeFirst, newStacks, ItemGroup.StackVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void addBefore(ItemConvertible beforeFirst, Collection<ItemStack> newStacks, ItemGroup.StackVisibility visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case PARENT_AND_SEARCH_TABS: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
                break;
            }
            case PARENT_TAB_ONLY: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                break;
            }
            case SEARCH_TAB_ONLY: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addBefore(ItemStack beforeFirst, Collection<ItemStack> newStacks, ItemGroup.StackVisibility visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case PARENT_AND_SEARCH_TABS: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
                break;
            }
            case PARENT_TAB_ONLY: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                break;
            }
            case SEARCH_TAB_ONLY: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addBefore(Predicate<ItemStack> beforeFirst, Collection<ItemStack> newStacks, ItemGroup.StackVisibility visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case PARENT_AND_SEARCH_TABS: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
                break;
            }
            case PARENT_TAB_ONLY: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                break;
            }
            case SEARCH_TAB_ONLY: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
            }
        }
    }

    private boolean isEnabled(ItemStack stack) {
        return stack.getItem().isEnabled(this.getEnabledFeatures());
    }

    private Collection<ItemStack> getEnabledStacks(Collection<ItemStack> newStacks) {
        if (newStacks.stream().allMatch(this::isEnabled)) {
            return newStacks;
        }
        return newStacks.stream().filter(this::isEnabled).toList();
    }

    private static void addBefore(Predicate<ItemStack> predicate, Collection<ItemStack> newStacks, List<ItemStack> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        for (int i = 0; i < addTo.size(); ++i) {
            if (!predicate.test(addTo.get(i))) continue;
            addTo.subList(i, i).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addAfter(Predicate<ItemStack> predicate, Collection<ItemStack> newStacks, List<ItemStack> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        for (int i = addTo.size() - 1; i >= 0; --i) {
            if (!predicate.test(addTo.get(i))) continue;
            addTo.subList(i + 1, i + 1).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addBefore(ItemStack anchor, Collection<ItemStack> newStacks, List<ItemStack> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        for (int i = 0; i < addTo.size(); ++i) {
            if (!ItemStack.canCombine((ItemStack)anchor, (ItemStack)addTo.get(i))) continue;
            addTo.subList(i, i).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addAfter(ItemStack anchor, Collection<ItemStack> newStacks, List<ItemStack> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        for (int i = addTo.size() - 1; i >= 0; --i) {
            if (!ItemStack.canCombine((ItemStack)anchor, (ItemStack)addTo.get(i))) continue;
            addTo.subList(i + 1, i + 1).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addBefore(ItemConvertible anchor, Collection<ItemStack> newStacks, List<ItemStack> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        Item anchorItem = anchor.asItem();
        for (int i = 0; i < addTo.size(); ++i) {
            if (!addTo.get(i).isOf(anchorItem)) continue;
            addTo.subList(i, i).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addAfter(ItemConvertible anchor, Collection<ItemStack> newStacks, List<ItemStack> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        Item anchorItem = anchor.asItem();
        for (int i = addTo.size() - 1; i >= 0; --i) {
            if (!addTo.get(i).isOf(anchorItem)) continue;
            addTo.subList(i + 1, i + 1).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void checkStacks(Collection<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            FabricItemGroupEntries.checkStack(stack);
        }
    }

    private static void checkStack(ItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Cannot add empty stack");
        }
        if (stack.getCount() != 1) {
            throw new IllegalArgumentException("Stack size must be exactly 1 for stack: " + String.valueOf(stack));
        }
    }
}

