/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.gametest;

import java.lang.reflect.Method;
import java.util.Locale;
import net.fabricmc.fabric.impl.gametest.FabricGameTestHelper;
import net.fabricmc.fabric.impl.gametest.FabricGameTestModInitializer;
import net.minecraft.test.GameTest;
import net.minecraft.test.StructureTestUtil;
import net.minecraft.test.TestFunction;
import net.minecraft.test.TestFunctions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TestFunctions.class})
public abstract class TestFunctionsMixin {
    @Inject(at={@At(value="HEAD")}, method={"getTestFunction(Ljava/lang/reflect/Method;)Lnet/minecraft/test/TestFunction;"}, cancellable=true)
    private static void getTestFunction(Method method, CallbackInfoReturnable<TestFunction> cir) {
        GameTest gameTest = method.getAnnotation(GameTest.class);
        String testSuiteName = method.getDeclaringClass().getSimpleName().toLowerCase(Locale.ROOT);
        String testCaseName = testSuiteName + "." + method.getName().toLowerCase(Locale.ROOT);
        String modId = FabricGameTestModInitializer.getModIdForTestClass(method.getDeclaringClass());
        String structureName = "%s:%s".formatted(modId, testCaseName);
        if (!gameTest.templateName().isEmpty()) {
            structureName = gameTest.templateName();
        }
        TestFunction testFunction = new TestFunction(gameTest.batchId(), testCaseName, structureName, StructureTestUtil.getRotation((int)gameTest.rotation()), gameTest.tickLimit(), gameTest.duration(), gameTest.required(), gameTest.requiredSuccesses(), gameTest.maxAttempts(), FabricGameTestHelper.getTestMethodInvoker(method));
        cir.setReturnValue((Object)testFunction);
    }
}

