/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.networking.v1;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.network.ClientPlayNetworkHandler;

@Environment(value=EnvType.CLIENT)
public final class ClientPlayConnectionEvents {
    public static final Event<Init> INIT = EventFactory.createArrayBacked(Init.class, callbacks -> (handler, client) -> {
        for (Init callback : callbacks) {
            callback.onPlayInit(handler, client);
        }
    });
    public static final Event<Join> JOIN = EventFactory.createArrayBacked(Join.class, callbacks -> (handler, sender, client) -> {
        for (Join callback : callbacks) {
            callback.onPlayReady(handler, sender, client);
        }
    });
    public static final Event<Disconnect> DISCONNECT = EventFactory.createArrayBacked(Disconnect.class, callbacks -> (handler, client) -> {
        for (Disconnect callback : callbacks) {
            callback.onPlayDisconnect(handler, client);
        }
    });

    private ClientPlayConnectionEvents() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Disconnect {
        public void onPlayDisconnect(ClientPlayNetworkHandler var1, MinecraftClient var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Join {
        public void onPlayReady(ClientPlayNetworkHandler var1, PacketSender var2, MinecraftClient var3);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Init {
        public void onPlayInit(ClientPlayNetworkHandler var1, MinecraftClient var2);
    }
}

