/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.minecraft.client.render.VertexConsumer;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
abstract class AbstractRenderContext
implements RenderContext {
    private static final RenderContext.QuadTransform NO_TRANSFORM = q -> true;
    private RenderContext.QuadTransform activeTransform = NO_TRANSFORM;
    private final ObjectArrayList<RenderContext.QuadTransform> transformStack = new ObjectArrayList();
    private final RenderContext.QuadTransform stackTransform = q -> {
        int i = this.transformStack.size() - 1;
        while (i >= 0) {
            if (((RenderContext.QuadTransform)this.transformStack.get(i--)).transform(q)) continue;
            return false;
        }
        return true;
    };
    @Deprecated
    private final Consumer<Mesh> meshConsumer = mesh -> mesh.outputTo(this.getEmitter());
    protected Matrix4f matrix;
    protected Matrix3f normalMatrix;
    protected int overlay;
    private final Vector4f posVec = new Vector4f();
    private final Vector3f normalVec = new Vector3f();

    AbstractRenderContext() {
    }

    protected final boolean transform(MutableQuadView q) {
        return this.activeTransform.transform(q);
    }

    public boolean hasTransform() {
        return this.activeTransform != NO_TRANSFORM;
    }

    public void pushTransform(RenderContext.QuadTransform transform) {
        if (transform == null) {
            throw new NullPointerException("Renderer received null QuadTransform.");
        }
        this.transformStack.push((Object)transform);
        if (this.transformStack.size() == 1) {
            this.activeTransform = transform;
        } else if (this.transformStack.size() == 2) {
            this.activeTransform = this.stackTransform;
        }
    }

    public void popTransform() {
        this.transformStack.pop();
        if (this.transformStack.size() == 0) {
            this.activeTransform = NO_TRANSFORM;
        } else if (this.transformStack.size() == 1) {
            this.activeTransform = (RenderContext.QuadTransform)this.transformStack.get(0);
        }
    }

    @Deprecated
    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    protected void bufferQuad(MutableQuadViewImpl quad, VertexConsumer vertexConsumer) {
        Vector4f posVec = this.posVec;
        Vector3f normalVec = this.normalVec;
        boolean useNormals = quad.hasVertexNormals();
        if (useNormals) {
            quad.populateMissingNormals();
        } else {
            normalVec.set((Vector3fc)quad.faceNormal());
            normalVec.mul((Matrix3fc)this.normalMatrix);
        }
        for (int i = 0; i < 4; ++i) {
            posVec.set(quad.x(i), quad.y(i), quad.z(i), 1.0f);
            posVec.mul((Matrix4fc)this.matrix);
            vertexConsumer.vertex((double)posVec.x(), (double)posVec.y(), (double)posVec.z());
            int color = quad.color(i);
            vertexConsumer.color(color >>> 16 & 0xFF, color >>> 8 & 0xFF, color & 0xFF, color >>> 24 & 0xFF);
            vertexConsumer.texture(quad.u(i), quad.v(i));
            vertexConsumer.overlay(this.overlay);
            vertexConsumer.light(quad.lightmap(i));
            if (useNormals) {
                quad.copyNormal(i, normalVec);
                normalVec.mul((Matrix3fc)this.normalMatrix);
            }
            vertexConsumer.normal(normalVec.x(), normalVec.y(), normalVec.z());
            vertexConsumer.next();
        }
    }
}

