/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.aocalc;

import java.util.BitSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.indigo.Indigo;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoConfig;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoFace;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoFaceData;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.VanillaAoHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.QuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.block.BlockState;
import net.minecraft.client.render.WorldRenderer;
import net.minecraft.client.render.block.BlockModelRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.BlockRenderView;
import net.minecraft.world.BlockView;
import net.minecraft.world.LightType;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public abstract class AoCalculator {
    private static final int[][] VERTEX_MAP = new int[6][4];
    private static final Logger LOGGER;
    private final BlockModelRenderer.AmbientOcclusionCalculator vanillaCalc;
    private final BlockPos.Mutable lightPos = new BlockPos.Mutable();
    private final BlockPos.Mutable searchPos = new BlockPos.Mutable();
    protected final BlockRenderInfo blockInfo;
    private final AoFaceData[] faceData = new AoFaceData[24];
    private int completionFlags = 0;
    private final float[] w = new float[4];
    public final float[] ao = new float[4];
    public final int[] light = new int[4];
    private final float[] vanillaAoData = new float[Direction.values().length * 2];
    private final BitSet vanillaAoControlBits = new BitSet(3);
    private final int[] vertexData = new int[EncodingFormat.QUAD_STRIDE];
    AoFaceData tmpFace = new AoFaceData();
    private final Vector3f vertexNormal = new Vector3f();

    public abstract int light(BlockPos var1, BlockState var2);

    public abstract float ao(BlockPos var1, BlockState var2);

    public AoCalculator(BlockRenderInfo blockInfo) {
        this.blockInfo = blockInfo;
        this.vanillaCalc = new BlockModelRenderer.AmbientOcclusionCalculator();
        for (int i = 0; i < 24; ++i) {
            this.faceData[i] = new AoFaceData();
        }
    }

    public void clear() {
        this.completionFlags = 0;
    }

    public void compute(MutableQuadViewImpl quad, boolean isVanilla) {
        boolean shouldCompare;
        AoConfig config = Indigo.AMBIENT_OCCLUSION_MODE;
        switch (config) {
            case VANILLA: {
                this.calcVanilla(quad);
                shouldCompare = false;
                break;
            }
            case EMULATE: {
                this.calcFastVanilla(quad);
                shouldCompare = Indigo.DEBUG_COMPARE_LIGHTING && isVanilla;
                break;
            }
            default: {
                if (isVanilla) {
                    shouldCompare = Indigo.DEBUG_COMPARE_LIGHTING;
                    this.calcFastVanilla(quad);
                    break;
                }
                shouldCompare = false;
                this.calcEnhanced(quad);
                break;
            }
            case ENHANCED: {
                shouldCompare = false;
                this.calcEnhanced(quad);
            }
        }
        if (shouldCompare) {
            float[] vanillaAo = new float[4];
            int[] vanillaLight = new int[4];
            this.calcVanilla(quad, vanillaAo, vanillaLight);
            for (int i = 0; i < 4; ++i) {
                if (this.light[i] == vanillaLight[i] && MathHelper.approximatelyEquals((float)this.ao[i], (float)vanillaAo[i])) continue;
                LOGGER.info(String.format("Mismatch for %s @ %s", this.blockInfo.blockState.toString(), this.blockInfo.blockPos.toString()));
                LOGGER.info(String.format("Flags = %d, LightFace = %s", quad.geometryFlags(), quad.lightFace().toString()));
                LOGGER.info(String.format("    Old Multiplier: %.2f, %.2f, %.2f, %.2f", Float.valueOf(vanillaAo[0]), Float.valueOf(vanillaAo[1]), Float.valueOf(vanillaAo[2]), Float.valueOf(vanillaAo[3])));
                LOGGER.info(String.format("    New Multiplier: %.2f, %.2f, %.2f, %.2f", Float.valueOf(this.ao[0]), Float.valueOf(this.ao[1]), Float.valueOf(this.ao[2]), Float.valueOf(this.ao[3])));
                LOGGER.info(String.format("    Old Brightness: %s, %s, %s, %s", Integer.toHexString(vanillaLight[0]), Integer.toHexString(vanillaLight[1]), Integer.toHexString(vanillaLight[2]), Integer.toHexString(vanillaLight[3])));
                LOGGER.info(String.format("    New Brightness: %s, %s, %s, %s", Integer.toHexString(this.light[0]), Integer.toHexString(this.light[1]), Integer.toHexString(this.light[2]), Integer.toHexString(this.light[3])));
                break;
            }
        }
    }

    private void calcVanilla(MutableQuadViewImpl quad) {
        this.calcVanilla(quad, this.ao, this.light);
    }

    private void calcVanilla(MutableQuadViewImpl quad, float[] aoDest, int[] lightDest) {
        this.vanillaAoControlBits.clear();
        Direction lightFace = quad.lightFace();
        quad.toVanilla(this.vertexData, 0);
        VanillaAoHelper.updateShape(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.vertexData, lightFace, this.vanillaAoData, this.vanillaAoControlBits);
        this.vanillaCalc.apply(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, lightFace, this.vanillaAoData, this.vanillaAoControlBits, quad.hasShade());
        System.arraycopy(this.vanillaCalc.brightness, 0, aoDest, 0, 4);
        System.arraycopy(this.vanillaCalc.light, 0, lightDest, 0, 4);
    }

    private void calcFastVanilla(MutableQuadViewImpl quad) {
        int flags = quad.geometryFlags();
        if ((flags & 4) == 0 && (flags & 2) != 0 && this.blockInfo.blockState.isFullCube((BlockView)this.blockInfo.blockView, this.blockInfo.blockPos)) {
            flags |= 4;
        }
        if ((flags & 1) == 0) {
            this.vanillaPartialFace(quad, quad.lightFace(), (flags & 4) != 0, quad.hasShade());
        } else {
            this.vanillaFullFace(quad, quad.lightFace(), (flags & 4) != 0, quad.hasShade());
        }
    }

    private void calcEnhanced(MutableQuadViewImpl quad) {
        switch (quad.geometryFlags()) {
            case 6: 
            case 7: {
                this.vanillaPartialFace(quad, quad.lightFace(), true, quad.hasShade());
                break;
            }
            case 2: 
            case 3: {
                this.blendedPartialFace(quad, quad.lightFace(), quad.hasShade());
                break;
            }
            default: {
                this.irregularFace(quad, quad.hasShade());
            }
        }
    }

    private void vanillaFullFace(QuadViewImpl quad, Direction lightFace, boolean isOnLightFace, boolean shade) {
        this.computeFace(lightFace, isOnLightFace, shade).toArray(this.ao, this.light, VERTEX_MAP[lightFace.getId()]);
    }

    private void vanillaPartialFace(QuadViewImpl quad, Direction lightFace, boolean isOnLightFace, boolean shade) {
        AoFaceData faceData = this.computeFace(lightFace, isOnLightFace, shade);
        AoFace.WeightFunction wFunc = AoFace.get((Direction)lightFace).weightFunc;
        float[] w = this.w;
        for (int i = 0; i < 4; ++i) {
            wFunc.apply(quad, i, w);
            this.light[i] = faceData.weightedCombinedLight(w);
            this.ao[i] = faceData.weigtedAo(w);
        }
    }

    private AoFaceData blendedInsetFace(QuadViewImpl quad, int vertexIndex, Direction lightFace, boolean shade) {
        float w1 = AoFace.get((Direction)lightFace).depthFunc.apply(quad, vertexIndex);
        float w0 = 1.0f - w1;
        return AoFaceData.weightedMean(this.computeFace(lightFace, true, shade), w0, this.computeFace(lightFace, false, shade), w1, this.tmpFace);
    }

    private AoFaceData gatherInsetFace(QuadViewImpl quad, int vertexIndex, Direction lightFace, boolean shade) {
        float w1 = AoFace.get((Direction)lightFace).depthFunc.apply(quad, vertexIndex);
        if (MathHelper.approximatelyEquals((float)w1, (float)0.0f)) {
            return this.computeFace(lightFace, true, shade);
        }
        if (MathHelper.approximatelyEquals((float)w1, (float)1.0f)) {
            return this.computeFace(lightFace, false, shade);
        }
        float w0 = 1.0f - w1;
        return AoFaceData.weightedMean(this.computeFace(lightFace, true, shade), w0, this.computeFace(lightFace, false, shade), w1, this.tmpFace);
    }

    private void blendedPartialFace(QuadViewImpl quad, Direction lightFace, boolean shade) {
        AoFaceData faceData = this.blendedInsetFace(quad, 0, lightFace, shade);
        AoFace.WeightFunction wFunc = AoFace.get((Direction)lightFace).weightFunc;
        for (int i = 0; i < 4; ++i) {
            wFunc.apply(quad, i, this.w);
            this.light[i] = faceData.weightedCombinedLight(this.w);
            this.ao[i] = faceData.weigtedAo(this.w);
        }
    }

    private void irregularFace(MutableQuadViewImpl quad, boolean shade) {
        Vector3f faceNorm = quad.faceNormal();
        float[] w = this.w;
        float[] aoResult = this.ao;
        int[] lightResult = this.light;
        for (int i = 0; i < 4; ++i) {
            float z;
            float y;
            Vector3f normal = quad.hasNormal(i) ? quad.copyNormal(i, this.vertexNormal) : faceNorm;
            float ao = 0.0f;
            float sky = 0.0f;
            float block = 0.0f;
            float maxAo = 0.0f;
            int maxSky = 0;
            int maxBlock = 0;
            float x = normal.x();
            if (!MathHelper.approximatelyEquals((float)0.0f, (float)x)) {
                Direction face = x > 0.0f ? Direction.EAST : Direction.WEST;
                AoFaceData fd = this.gatherInsetFace(quad, i, face, shade);
                AoFace.get((Direction)face).weightFunc.apply(quad, i, w);
                float n = x * x;
                float a = fd.weigtedAo(w);
                int s = fd.weigtedSkyLight(w);
                int b = fd.weigtedBlockLight(w);
                ao += n * a;
                sky += n * (float)s;
                block += n * (float)b;
                maxAo = a;
                maxSky = s;
                maxBlock = b;
            }
            if (!MathHelper.approximatelyEquals((float)0.0f, (float)(y = normal.y()))) {
                Direction face = y > 0.0f ? Direction.UP : Direction.DOWN;
                AoFaceData fd = this.gatherInsetFace(quad, i, face, shade);
                AoFace.get((Direction)face).weightFunc.apply(quad, i, w);
                float n = y * y;
                float a = fd.weigtedAo(w);
                int s = fd.weigtedSkyLight(w);
                int b = fd.weigtedBlockLight(w);
                ao += n * a;
                sky += n * (float)s;
                block += n * (float)b;
                maxAo = Math.max(maxAo, a);
                maxSky = Math.max(maxSky, s);
                maxBlock = Math.max(maxBlock, b);
            }
            if (!MathHelper.approximatelyEquals((float)0.0f, (float)(z = normal.z()))) {
                Direction face = z > 0.0f ? Direction.SOUTH : Direction.NORTH;
                AoFaceData fd = this.gatherInsetFace(quad, i, face, shade);
                AoFace.get((Direction)face).weightFunc.apply(quad, i, w);
                float n = z * z;
                float a = fd.weigtedAo(w);
                int s = fd.weigtedSkyLight(w);
                int b = fd.weigtedBlockLight(w);
                ao += n * a;
                sky += n * (float)s;
                block += n * (float)b;
                maxAo = Math.max(maxAo, a);
                maxSky = Math.max(maxSky, s);
                maxBlock = Math.max(maxBlock, b);
            }
            aoResult[i] = (ao + maxAo) * 0.5f;
            lightResult[i] = ((int)((sky + (float)maxSky) * 0.5f) & 0xF0) << 16 | (int)((block + (float)maxBlock) * 0.5f) & 0xF0;
        }
    }

    private AoFaceData computeFace(Direction lightFace, boolean isOnBlockFace, boolean shade) {
        int faceDataIndex = shade ? (isOnBlockFace ? lightFace.getId() : lightFace.getId() + 6) : (isOnBlockFace ? lightFace.getId() + 12 : lightFace.getId() + 18);
        int mask = 1 << faceDataIndex;
        AoFaceData result = this.faceData[faceDataIndex];
        if ((this.completionFlags & mask) == 0) {
            this.completionFlags |= mask;
            this.computeFace(result, lightFace, isOnBlockFace, shade);
        }
        return result;
    }

    private void computeFace(AoFaceData result, Direction lightFace, boolean isOnBlockFace, boolean shade) {
        boolean emCenter;
        int lightCenter;
        boolean cEm3;
        int cLight3;
        float cAo3;
        boolean cEm2;
        int cLight2;
        float cAo2;
        boolean cEm1;
        int cLight1;
        float cAo1;
        boolean cEm0;
        int cLight0;
        float cAo0;
        boolean isClear3;
        BlockRenderView world = this.blockInfo.blockView;
        BlockPos pos = this.blockInfo.blockPos;
        BlockState blockState = this.blockInfo.blockState;
        BlockPos.Mutable lightPos = this.lightPos;
        BlockPos.Mutable searchPos = this.searchPos;
        if (isOnBlockFace) {
            lightPos.set((Vec3i)pos, lightFace);
        } else {
            lightPos.set((Vec3i)pos);
        }
        AoFace aoFace = AoFace.get(lightFace);
        searchPos.set((Vec3i)lightPos, aoFace.neighbors[0]);
        BlockState searchState = world.getBlockState((BlockPos)searchPos);
        int light0 = this.light((BlockPos)searchPos, searchState);
        float ao0 = this.ao((BlockPos)searchPos, searchState);
        boolean em0 = this.hasEmissiveLighting(world, (BlockPos)searchPos, searchState);
        if (!Indigo.FIX_SMOOTH_LIGHTING_OFFSET) {
            searchPos.move(lightFace);
            searchState = world.getBlockState((BlockPos)searchPos);
        }
        boolean isClear0 = !searchState.shouldBlockVision((BlockView)world, (BlockPos)searchPos) || searchState.getOpacity((BlockView)world, (BlockPos)searchPos) == 0;
        searchPos.set((Vec3i)lightPos, aoFace.neighbors[1]);
        searchState = world.getBlockState((BlockPos)searchPos);
        int light1 = this.light((BlockPos)searchPos, searchState);
        float ao1 = this.ao((BlockPos)searchPos, searchState);
        boolean em1 = this.hasEmissiveLighting(world, (BlockPos)searchPos, searchState);
        if (!Indigo.FIX_SMOOTH_LIGHTING_OFFSET) {
            searchPos.move(lightFace);
            searchState = world.getBlockState((BlockPos)searchPos);
        }
        boolean isClear1 = !searchState.shouldBlockVision((BlockView)world, (BlockPos)searchPos) || searchState.getOpacity((BlockView)world, (BlockPos)searchPos) == 0;
        searchPos.set((Vec3i)lightPos, aoFace.neighbors[2]);
        searchState = world.getBlockState((BlockPos)searchPos);
        int light2 = this.light((BlockPos)searchPos, searchState);
        float ao2 = this.ao((BlockPos)searchPos, searchState);
        boolean em2 = this.hasEmissiveLighting(world, (BlockPos)searchPos, searchState);
        if (!Indigo.FIX_SMOOTH_LIGHTING_OFFSET) {
            searchPos.move(lightFace);
            searchState = world.getBlockState((BlockPos)searchPos);
        }
        boolean isClear2 = !searchState.shouldBlockVision((BlockView)world, (BlockPos)searchPos) || searchState.getOpacity((BlockView)world, (BlockPos)searchPos) == 0;
        searchPos.set((Vec3i)lightPos, aoFace.neighbors[3]);
        searchState = world.getBlockState((BlockPos)searchPos);
        int light3 = this.light((BlockPos)searchPos, searchState);
        float ao3 = this.ao((BlockPos)searchPos, searchState);
        boolean em3 = this.hasEmissiveLighting(world, (BlockPos)searchPos, searchState);
        if (!Indigo.FIX_SMOOTH_LIGHTING_OFFSET) {
            searchPos.move(lightFace);
            searchState = world.getBlockState((BlockPos)searchPos);
        }
        boolean bl = isClear3 = !searchState.shouldBlockVision((BlockView)world, (BlockPos)searchPos) || searchState.getOpacity((BlockView)world, (BlockPos)searchPos) == 0;
        if (!isClear2 && !isClear0) {
            cAo0 = ao0;
            cLight0 = light0;
            cEm0 = em0;
        } else {
            searchPos.set((Vec3i)lightPos).move(aoFace.neighbors[0]).move(aoFace.neighbors[2]);
            searchState = world.getBlockState((BlockPos)searchPos);
            cAo0 = this.ao((BlockPos)searchPos, searchState);
            cLight0 = this.light((BlockPos)searchPos, searchState);
            cEm0 = this.hasEmissiveLighting(world, (BlockPos)searchPos, searchState);
        }
        if (!isClear3 && !isClear0) {
            cAo1 = ao0;
            cLight1 = light0;
            cEm1 = em0;
        } else {
            searchPos.set((Vec3i)lightPos).move(aoFace.neighbors[0]).move(aoFace.neighbors[3]);
            searchState = world.getBlockState((BlockPos)searchPos);
            cAo1 = this.ao((BlockPos)searchPos, searchState);
            cLight1 = this.light((BlockPos)searchPos, searchState);
            cEm1 = this.hasEmissiveLighting(world, (BlockPos)searchPos, searchState);
        }
        if (!isClear2 && !isClear1) {
            cAo2 = ao1;
            cLight2 = light1;
            cEm2 = em1;
        } else {
            searchPos.set((Vec3i)lightPos).move(aoFace.neighbors[1]).move(aoFace.neighbors[2]);
            searchState = world.getBlockState((BlockPos)searchPos);
            cAo2 = this.ao((BlockPos)searchPos, searchState);
            cLight2 = this.light((BlockPos)searchPos, searchState);
            cEm2 = this.hasEmissiveLighting(world, (BlockPos)searchPos, searchState);
        }
        if (!isClear3 && !isClear1) {
            cAo3 = ao1;
            cLight3 = light1;
            cEm3 = em1;
        } else {
            searchPos.set((Vec3i)lightPos).move(aoFace.neighbors[1]).move(aoFace.neighbors[3]);
            searchState = world.getBlockState((BlockPos)searchPos);
            cAo3 = this.ao((BlockPos)searchPos, searchState);
            cLight3 = this.light((BlockPos)searchPos, searchState);
            cEm3 = this.hasEmissiveLighting(world, (BlockPos)searchPos, searchState);
        }
        searchPos.set((Vec3i)pos, lightFace);
        searchState = world.getBlockState((BlockPos)searchPos);
        if (isOnBlockFace || !searchState.isOpaqueFullCube((BlockView)world, (BlockPos)searchPos)) {
            lightCenter = this.light((BlockPos)searchPos, searchState);
            emCenter = this.hasEmissiveLighting(world, (BlockPos)searchPos, searchState);
        } else {
            lightCenter = this.light(pos, blockState);
            emCenter = this.hasEmissiveLighting(world, pos, blockState);
        }
        float aoCenter = this.ao((BlockPos)lightPos, world.getBlockState((BlockPos)lightPos));
        float worldBrightness = world.getBrightness(lightFace, shade);
        result.a0 = (ao3 + ao0 + cAo1 + aoCenter) * 0.25f * worldBrightness;
        result.a1 = (ao2 + ao0 + cAo0 + aoCenter) * 0.25f * worldBrightness;
        result.a2 = (ao2 + ao1 + cAo2 + aoCenter) * 0.25f * worldBrightness;
        result.a3 = (ao3 + ao1 + cAo3 + aoCenter) * 0.25f * worldBrightness;
        result.l0(AoCalculator.meanBrightness(light3, light0, cLight1, lightCenter, em3, em0, cEm1, emCenter));
        result.l1(AoCalculator.meanBrightness(light2, light0, cLight0, lightCenter, em2, em0, cEm0, emCenter));
        result.l2(AoCalculator.meanBrightness(light2, light1, cLight2, lightCenter, em2, em1, cEm2, emCenter));
        result.l3(AoCalculator.meanBrightness(light3, light1, cLight3, lightCenter, em3, em1, cEm3, emCenter));
    }

    public static int getLightmapCoordinates(BlockRenderView world, BlockState state, BlockPos pos) {
        if (Indigo.FIX_EMISSIVE_LIGHTING) {
            int k;
            int i = world.getLightLevel(LightType.SKY, pos);
            int j = world.getLightLevel(LightType.BLOCK, pos);
            if (j < (k = state.getLuminance())) {
                j = k;
            }
            return i << 20 | j << 4;
        }
        return WorldRenderer.getLightmapCoordinates((BlockRenderView)world, (BlockState)state, (BlockPos)pos);
    }

    private boolean hasEmissiveLighting(BlockRenderView world, BlockPos pos, BlockState state) {
        if (Indigo.FIX_EMISSIVE_LIGHTING) {
            return state.hasEmissiveLighting((BlockView)world, pos);
        }
        return false;
    }

    private static int meanBrightness(int lightA, int lightB, int lightC, int lightD, boolean emA, boolean emB, boolean emC, boolean emD) {
        if (Indigo.FIX_MEAN_LIGHT_CALCULATION) {
            if (lightA == 0 || lightB == 0 || lightC == 0 || lightD == 0) {
                int min = AoCalculator.nonZeroMin(AoCalculator.nonZeroMin(lightA, lightB), AoCalculator.nonZeroMin(lightC, lightD));
                lightA = Math.max(lightA, min);
                lightB = Math.max(lightB, min);
                lightC = Math.max(lightC, min);
                lightD = Math.max(lightD, min);
            }
            if (Indigo.FIX_EMISSIVE_LIGHTING) {
                if (emA) {
                    lightA = 0xF000F0;
                }
                if (emB) {
                    lightB = 0xF000F0;
                }
                if (emC) {
                    lightC = 0xF000F0;
                }
                if (emD) {
                    lightD = 0xF000F0;
                }
            }
            return AoCalculator.meanInnerBrightness(lightA, lightB, lightC, lightD);
        }
        return AoCalculator.vanillaMeanBrightness(lightA, lightB, lightC, lightD);
    }

    private static int vanillaMeanBrightness(int a, int b, int c, int d) {
        if (a == 0) {
            a = d;
        }
        if (b == 0) {
            b = d;
        }
        if (c == 0) {
            c = d;
        }
        return a + b + c + d >> 2 & 0xFF00FF;
    }

    private static int meanInnerBrightness(int a, int b, int c, int d) {
        return a + b + c + d >> 2 & 0xFF00FF;
    }

    private static int nonZeroMin(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        return Math.min(a, b);
    }

    static {
        AoCalculator.VERTEX_MAP[Direction.DOWN.getId()] = new int[]{0, 1, 2, 3};
        AoCalculator.VERTEX_MAP[Direction.UP.getId()] = new int[]{2, 3, 0, 1};
        AoCalculator.VERTEX_MAP[Direction.NORTH.getId()] = new int[]{3, 0, 1, 2};
        AoCalculator.VERTEX_MAP[Direction.SOUTH.getId()] = new int[]{0, 1, 2, 3};
        AoCalculator.VERTEX_MAP[Direction.WEST.getId()] = new int[]{3, 0, 1, 2};
        AoCalculator.VERTEX_MAP[Direction.EAST.getId()] = new int[]{1, 2, 3, 0};
        LOGGER = LoggerFactory.getLogger(AoCalculator.class);
    }
}

