/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer;

import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.impl.client.indigo.renderer.material.MaterialFinderImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MeshBuilderImpl;
import net.minecraft.util.Identifier;

@Environment(value=EnvType.CLIENT)
public class IndigoRenderer
implements Renderer {
    public static final IndigoRenderer INSTANCE = new IndigoRenderer();
    public static final RenderMaterial MATERIAL_STANDARD = INSTANCE.materialFinder().find();
    private final HashMap<Identifier, RenderMaterial> materialMap = new HashMap();

    private IndigoRenderer() {
    }

    public MeshBuilder meshBuilder() {
        return new MeshBuilderImpl();
    }

    public MaterialFinder materialFinder() {
        return new MaterialFinderImpl();
    }

    public RenderMaterial materialById(Identifier id) {
        return this.materialMap.get(id);
    }

    public boolean registerMaterial(Identifier id, RenderMaterial material) {
        if (this.materialMap.containsKey(id)) {
            return false;
        }
        this.materialMap.put(id, material);
        return true;
    }

    static {
        INSTANCE.registerMaterial(RenderMaterial.MATERIAL_STANDARD, MATERIAL_STANDARD);
    }
}

