/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.nbt.NbtHelper;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringNbtReader;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.recipe.Ingredient;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;
import org.jetbrains.annotations.Nullable;

public class NbtIngredient
implements CustomIngredient {
    public static final CustomIngredientSerializer<NbtIngredient> SERIALIZER = new Serializer();
    private final Ingredient base;
    @Nullable
    private final NbtCompound nbt;
    private final boolean strict;

    public NbtIngredient(Ingredient base, @Nullable NbtCompound nbt, boolean strict) {
        if (nbt == null && !strict) {
            throw new IllegalArgumentException("NbtIngredient can only have null NBT in strict mode");
        }
        this.base = base;
        this.nbt = nbt;
        this.strict = strict;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (!this.base.test(stack)) {
            return false;
        }
        if (this.strict) {
            return Objects.equals(this.nbt, stack.getNbt());
        }
        return NbtHelper.matches((NbtElement)this.nbt, (NbtElement)stack.getNbt(), (boolean)true);
    }

    @Override
    public List<ItemStack> getMatchingStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(List.of(this.base.getMatchingStacks()));
        stacks.replaceAll(stack -> {
            ItemStack copy = stack.copy();
            if (this.nbt != null) {
                copy.setNbt(this.nbt.copy());
            }
            return copy;
        });
        stacks.removeIf(stack -> !this.base.test(stack));
        return stacks;
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public CustomIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements CustomIngredientSerializer<NbtIngredient> {
        private final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        private final Identifier id = new Identifier("fabric", "nbt");

        private Serializer() {
        }

        @Override
        public Identifier getIdentifier() {
            return this.id;
        }

        @Override
        public NbtIngredient read(JsonObject json) {
            Ingredient base = Ingredient.fromJson((JsonElement)json.get("base"));
            NbtCompound nbt = Serializer.readNbt(json.get("nbt"));
            boolean strict = JsonHelper.getBoolean((JsonObject)json, (String)"strict", (boolean)false);
            return new NbtIngredient(base, nbt, strict);
        }

        @Nullable
        private static NbtCompound readNbt(@Nullable JsonElement json) {
            if (json == null || json.isJsonNull()) {
                return null;
            }
            try {
                if (json.isJsonObject()) {
                    return StringNbtReader.parse((String)json.toString());
                }
                return StringNbtReader.parse((String)JsonHelper.asString((JsonElement)json, (String)"nbt"));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                throw new JsonSyntaxException("Invalid nbt tag: " + commandSyntaxException.getMessage());
            }
        }

        @Override
        public void write(JsonObject json, NbtIngredient ingredient) {
            json.add("base", ingredient.base.toJson());
            json.addProperty("strict", Boolean.valueOf(ingredient.strict));
            if (ingredient.nbt != null) {
                json.add("nbt", (JsonElement)NbtOps.INSTANCE.convertTo((DynamicOps)JsonOps.INSTANCE, (NbtElement)ingredient.nbt));
            }
        }

        @Override
        public NbtIngredient read(PacketByteBuf buf) {
            Ingredient base = Ingredient.fromPacket((PacketByteBuf)buf);
            NbtCompound nbt = buf.readNbt();
            boolean strict = buf.readBoolean();
            return new NbtIngredient(base, nbt, strict);
        }

        @Override
        public void write(PacketByteBuf buf, NbtIngredient ingredient) {
            ingredient.base.write(buf);
            buf.writeNbt(ingredient.nbt);
            buf.writeBoolean(ingredient.strict);
        }
    }
}

