/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.client;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.FutureListeners;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.impl.networking.AbstractNetworkAddon;
import net.fabricmc.fabric.impl.networking.GenericFutureListenerHolder;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.client.accessor.ClientLoginNetworkHandlerAccessor;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.network.ClientLoginNetworkHandler;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.PacketCallbacks;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.c2s.login.LoginQueryResponseC2SPacket;
import net.minecraft.network.packet.s2c.login.LoginQueryRequestS2CPacket;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientLoginNetworkAddon
extends AbstractNetworkAddon<ClientLoginNetworking.LoginQueryRequestHandler> {
    private final ClientLoginNetworkHandler handler;
    private final MinecraftClient client;
    private boolean firstResponse = true;

    public ClientLoginNetworkAddon(ClientLoginNetworkHandler handler, MinecraftClient client) {
        super(ClientNetworkingImpl.LOGIN, "ClientLoginNetworkAddon for Client");
        this.handler = handler;
        this.client = client;
        ((ClientLoginConnectionEvents.Init)ClientLoginConnectionEvents.INIT.invoker()).onLoginStart(this.handler, this.client);
        this.receiver.startSession(this);
    }

    public boolean handlePacket(LoginQueryRequestS2CPacket packet) {
        return this.handlePacket(packet.getQueryId(), packet.getChannel(), packet.getPayload());
    }

    private boolean handlePacket(int queryId, Identifier channelName, PacketByteBuf originalBuf) {
        ClientLoginNetworking.LoginQueryRequestHandler handler;
        this.logger.debug("Handling inbound login response with id {} and channel with name {}", (Object)queryId, (Object)channelName);
        if (this.firstResponse) {
            for (Map.Entry<Identifier, ClientLoginNetworking.LoginQueryRequestHandler> entry : ClientNetworkingImpl.LOGIN.getHandlers().entrySet()) {
                ClientLoginNetworking.registerReceiver(entry.getKey(), entry.getValue());
            }
            ((ClientLoginConnectionEvents.QueryStart)ClientLoginConnectionEvents.QUERY_START.invoker()).onLoginQueryStart(this.handler, this.client);
            this.firstResponse = false;
        }
        if ((handler = (ClientLoginNetworking.LoginQueryRequestHandler)this.getHandler(channelName)) == null) {
            return false;
        }
        PacketByteBuf buf = PacketByteBufs.slice((ByteBuf)originalBuf);
        ArrayList futureListeners = new ArrayList();
        try {
            CompletableFuture<@Nullable PacketByteBuf> future = handler.receive(this.client, this.handler, buf, futureListeners::add);
            future.thenAccept(result -> {
                LoginQueryResponseC2SPacket packet = new LoginQueryResponseC2SPacket(queryId, result);
                GenericFutureListener<Future<Void>> listener = null;
                for (GenericFutureListener each : futureListeners) {
                    listener = FutureListeners.union(listener, each);
                }
                ((ClientLoginNetworkHandlerAccessor)this.handler).getConnection().send((Packet)packet, (PacketCallbacks)GenericFutureListenerHolder.create(listener));
            });
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel with name \"{}\"", (Object)channelName, (Object)ex);
            throw ex;
        }
        return true;
    }

    @Override
    protected void handleRegistration(Identifier channelName) {
    }

    @Override
    protected void handleUnregistration(Identifier channelName) {
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ClientLoginConnectionEvents.Disconnect)ClientLoginConnectionEvents.DISCONNECT.invoker()).onLoginDisconnect(this.handler, this.client);
        this.receiver.endSession(this);
    }

    public void handlePlayTransition() {
        this.receiver.endSession(this);
    }

    @Override
    protected boolean isReservedChannel(Identifier channelName) {
        return false;
    }
}

