/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.impl.networking.client.ClientPlayNetworkAddon;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.network.ClientPlayNetworkHandler;
import net.minecraft.client.network.ClientPlayerEntity;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.listener.ServerPlayPacketListener;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientPlayNetworking {
    public static boolean registerGlobalReceiver(Identifier channelName, PlayChannelHandler channelHandler) {
        return ClientNetworkingImpl.PLAY.registerGlobalReceiver(channelName, channelHandler);
    }

    public static <T extends FabricPacket> boolean registerGlobalReceiver(final PacketType<T> type, final PlayPacketHandler<T> handler) {
        return ClientPlayNetworking.registerGlobalReceiver(type.getId(), new PlayChannelHandlerProxy<T>(){

            @Override
            public PlayPacketHandler<T> getOriginalHandler() {
                return handler;
            }

            @Override
            public void receive(MinecraftClient client, ClientPlayNetworkHandler networkHandler, PacketByteBuf buf, PacketSender sender) {
                Object packet = type.read(buf);
                if (client.isOnThread()) {
                    handler.receive(packet, client.player, sender);
                } else {
                    client.execute(() -> {
                        if (networkHandler.getConnection().isOpen()) {
                            handler.receive(packet, client.player, sender);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public static PlayChannelHandler unregisterGlobalReceiver(Identifier channelName) {
        return ClientNetworkingImpl.PLAY.unregisterGlobalReceiver(channelName);
    }

    @Nullable
    public static <T extends FabricPacket> PlayPacketHandler<T> unregisterGlobalReceiver(PacketType<T> type) {
        PlayPacketHandler playPacketHandler;
        PlayChannelHandler handler = ClientNetworkingImpl.PLAY.unregisterGlobalReceiver(type.getId());
        if (handler instanceof PlayChannelHandlerProxy) {
            PlayChannelHandlerProxy proxy = (PlayChannelHandlerProxy)handler;
            playPacketHandler = proxy.getOriginalHandler();
        } else {
            playPacketHandler = null;
        }
        return playPacketHandler;
    }

    public static Set<Identifier> getGlobalReceivers() {
        return ClientNetworkingImpl.PLAY.getChannels();
    }

    public static boolean registerReceiver(Identifier channelName, PlayChannelHandler channelHandler) {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.registerChannel(channelName, channelHandler);
        }
        throw new IllegalStateException("Cannot register receiver while not in game!");
    }

    public static <T extends FabricPacket> boolean registerReceiver(final PacketType<T> type, final PlayPacketHandler<T> handler) {
        return ClientPlayNetworking.registerReceiver(type.getId(), new PlayChannelHandlerProxy<T>(){

            @Override
            public PlayPacketHandler<T> getOriginalHandler() {
                return handler;
            }

            @Override
            public void receive(MinecraftClient client, ClientPlayNetworkHandler networkHandler, PacketByteBuf buf, PacketSender sender) {
                Object packet = type.read(buf);
                if (client.isOnThread()) {
                    handler.receive(packet, client.player, sender);
                } else {
                    client.execute(() -> {
                        if (networkHandler.getConnection().isOpen()) {
                            handler.receive(packet, client.player, sender);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public static PlayChannelHandler unregisterReceiver(Identifier channelName) throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return (PlayChannelHandler)addon.unregisterChannel(channelName);
        }
        throw new IllegalStateException("Cannot unregister receiver while not in game!");
    }

    @Nullable
    public static <T extends FabricPacket> PlayPacketHandler<T> unregisterReceiver(PacketType<T> type) {
        PlayPacketHandler playPacketHandler;
        PlayChannelHandler handler = ClientPlayNetworking.unregisterReceiver(type.getId());
        if (handler instanceof PlayChannelHandlerProxy) {
            PlayChannelHandlerProxy proxy = (PlayChannelHandlerProxy)handler;
            playPacketHandler = proxy.getOriginalHandler();
        } else {
            playPacketHandler = null;
        }
        return playPacketHandler;
    }

    public static Set<Identifier> getReceived() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getReceivableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the client can receive packets on while not in game!");
    }

    public static Set<Identifier> getSendable() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getSendableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not in game!");
    }

    public static boolean canSend(Identifier channelName) throws IllegalArgumentException {
        if (MinecraftClient.getInstance().getNetworkHandler() != null) {
            return ClientNetworkingImpl.getAddon(MinecraftClient.getInstance().getNetworkHandler()).getSendableChannels().contains(channelName);
        }
        return false;
    }

    public static boolean canSend(PacketType<?> type) {
        return ClientPlayNetworking.canSend(type.getId());
    }

    public static Packet<ServerPlayPacketListener> createC2SPacket(Identifier channelName, PacketByteBuf buf) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ClientNetworkingImpl.createPlayC2SPacket(channelName, buf);
    }

    public static PacketSender getSender() throws IllegalStateException {
        if (MinecraftClient.getInstance().getNetworkHandler() != null) {
            return ClientNetworkingImpl.getAddon(MinecraftClient.getInstance().getNetworkHandler());
        }
        throw new IllegalStateException("Cannot get packet sender when not in game!");
    }

    public static void send(Identifier channelName, PacketByteBuf buf) throws IllegalStateException {
        if (MinecraftClient.getInstance().getNetworkHandler() != null) {
            MinecraftClient.getInstance().getNetworkHandler().sendPacket(ClientPlayNetworking.createC2SPacket(channelName, buf));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    public static <T extends FabricPacket> void send(T packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        PacketByteBuf buf = PacketByteBufs.create();
        packet.write(buf);
        ClientPlayNetworking.send(packet.getType().getId(), buf);
    }

    private ClientPlayNetworking() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface PlayPacketHandler<T extends FabricPacket> {
        public void receive(T var1, ClientPlayerEntity var2, PacketSender var3);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface PlayChannelHandler {
        public void receive(MinecraftClient var1, ClientPlayNetworkHandler var2, PacketByteBuf var3, PacketSender var4);
    }

    @Environment(value=EnvType.CLIENT)
    private static interface PlayChannelHandlerProxy<T extends FabricPacket>
    extends PlayChannelHandler {
        public PlayPacketHandler<T> getOriginalHandler();
    }
}

