/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.recipe.ingredient;

import java.util.ArrayList;
import net.fabricmc.fabric.impl.recipe.ingredient.ShapelessMatch;
import net.minecraft.inventory.RecipeInputInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.Ingredient;
import net.minecraft.recipe.ShapelessRecipe;
import net.minecraft.recipe.book.CraftingRecipeCategory;
import net.minecraft.util.Identifier;
import net.minecraft.util.collection.DefaultedList;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShapelessRecipe.class})
public class ShapelessRecipeMixin {
    @Final
    @Shadow
    DefaultedList<Ingredient> field_9047;
    @Unique
    private boolean fabric_requiresTesting = false;

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void cacheRequiresTesting(Identifier id, String group, CraftingRecipeCategory category, ItemStack output, DefaultedList<Ingredient> input, CallbackInfo ci) {
        for (Ingredient ingredient : input) {
            if (!ingredient.requiresTesting()) continue;
            this.fabric_requiresTesting = true;
            break;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"matches"}, cancellable=true)
    public void customIngredientMatch(RecipeInputInventory craftingInventory, World world, CallbackInfoReturnable<Boolean> cir) {
        if (this.fabric_requiresTesting) {
            ArrayList<ItemStack> nonEmptyStacks = new ArrayList<ItemStack>(craftingInventory.size());
            for (int i = 0; i < craftingInventory.size(); ++i) {
                ItemStack stack = craftingInventory.getStack(i);
                if (stack.isEmpty()) continue;
                nonEmptyStacks.add(stack);
            }
            cir.setReturnValue((Object)ShapelessMatch.isMatch(nonEmptyStacks, this.field_9047));
        }
    }
}

