/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.recipe.Ingredient;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;

abstract class CombinedIngredient
implements CustomIngredient {
    protected final Ingredient[] ingredients;

    protected CombinedIngredient(Ingredient[] ingredients) {
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("ALL or ANY ingredient must have at least one sub-ingredient");
        }
        this.ingredients = ingredients;
    }

    @Override
    public boolean requiresTesting() {
        for (Ingredient ingredient : this.ingredients) {
            if (!ingredient.requiresTesting()) continue;
            return true;
        }
        return false;
    }

    static class Serializer<I extends CombinedIngredient>
    implements CustomIngredientSerializer<I> {
        private final Identifier identifier;
        private final Function<Ingredient[], I> factory;

        Serializer(Identifier identifier, Function<Ingredient[], I> factory) {
            this.identifier = identifier;
            this.factory = factory;
        }

        @Override
        public Identifier getIdentifier() {
            return this.identifier;
        }

        @Override
        public I read(JsonObject json) {
            JsonArray values = JsonHelper.getArray((JsonObject)json, (String)"ingredients");
            Ingredient[] ingredients = new Ingredient[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                ingredients[i] = Ingredient.fromJson((JsonElement)values.get(i));
            }
            return (I)((CombinedIngredient)this.factory.apply(ingredients));
        }

        @Override
        public void write(JsonObject json, I ingredient) {
            JsonArray values = new JsonArray();
            for (Ingredient value : ((CombinedIngredient)ingredient).ingredients) {
                values.add(value.toJson());
            }
            json.add("ingredients", (JsonElement)values);
        }

        @Override
        public I read(PacketByteBuf buf) {
            int size = buf.readVarInt();
            Ingredient[] ingredients = new Ingredient[size];
            for (int i = 0; i < size; ++i) {
                ingredients[i] = Ingredient.fromPacket((PacketByteBuf)buf);
            }
            return (I)((CombinedIngredient)this.factory.apply(ingredients));
        }

        @Override
        public void write(PacketByteBuf buf, I ingredient) {
            buf.writeVarInt(((CombinedIngredient)ingredient).ingredients.length);
            for (Ingredient value : ((CombinedIngredient)ingredient).ingredients) {
                value.write(buf);
            }
        }
    }
}

