/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.networking;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.DisconnectPacketSource;
import net.fabricmc.fabric.impl.networking.GenericFutureListenerHolder;
import net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions;
import net.fabricmc.fabric.impl.networking.PacketCallbackListener;
import net.minecraft.network.ClientConnection;
import net.minecraft.network.NetworkSide;
import net.minecraft.network.NetworkState;
import net.minecraft.network.PacketCallbacks;
import net.minecraft.network.listener.PacketListener;
import net.minecraft.network.packet.Packet;
import net.minecraft.text.MutableText;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ClientConnection.class})
abstract class ClientConnectionMixin
implements ChannelInfoHolder {
    @Shadow
    private PacketListener field_11652;
    @Unique
    private Collection<Identifier> playChannels;

    ClientConnectionMixin() {
    }

    @Shadow
    public abstract void method_10747(Text var1);

    @Shadow
    public abstract void method_10752(Packet<?> var1, @Nullable PacketCallbacks var2);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initAddedFields(NetworkSide side, CallbackInfo ci) {
        this.playChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Redirect(method={"exceptionCaught"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/ClientConnection;send(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/PacketCallbacks;)V"))
    private void resendOnExceptionCaught(ClientConnection self, Packet<?> packet, PacketCallbacks listener, ChannelHandlerContext context, Throwable ex) {
        PacketListener handler = this.field_11652;
        MutableText disconnectMessage = Text.translatable((String)"disconnect.genericReason", (Object[])new Object[]{"Internal Exception: " + String.valueOf(ex)});
        if (handler instanceof DisconnectPacketSource) {
            this.method_10752(((DisconnectPacketSource)handler).createDisconnectPacket((Text)disconnectMessage), listener);
        } else {
            this.method_10747((Text)disconnectMessage);
        }
    }

    @Inject(method={"sendImmediately"}, at={@At(value="FIELD", target="Lnet/minecraft/network/ClientConnection;packetsSentCounter:I")})
    private void checkPacket(Packet<?> packet, PacketCallbacks callback, CallbackInfo ci) {
        if (this.field_11652 instanceof PacketCallbackListener) {
            ((PacketCallbackListener)this.field_11652).sent(packet);
        }
    }

    @Inject(method={"channelInactive"}, at={@At(value="HEAD")})
    private void handleDisconnect(ChannelHandlerContext channelHandlerContext, CallbackInfo ci) {
        if (this.field_11652 instanceof NetworkHandlerExtensions) {
            ((NetworkHandlerExtensions)this.field_11652).getAddon().handleDisconnect();
        }
    }

    @Inject(method={"sendInternal"}, at={@At(value="INVOKE_ASSIGN", target="Lio/netty/channel/Channel;writeAndFlush(Ljava/lang/Object;)Lio/netty/channel/ChannelFuture;", remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void sendInternal(Packet<?> packet, @Nullable PacketCallbacks listener, NetworkState packetState, NetworkState currentState, CallbackInfo ci, ChannelFuture channelFuture) {
        if (listener instanceof GenericFutureListenerHolder) {
            GenericFutureListenerHolder holder = (GenericFutureListenerHolder)listener;
            channelFuture.addListener(holder.getDelegate());
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            ci.cancel();
        }
    }

    @Override
    public Collection<Identifier> getPendingChannelsNames() {
        return this.playChannels;
    }
}

