/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.listener.ClientPlayPacketListener;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerPlayNetworkHandler;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

public final class ServerPlayNetworking {
    public static boolean registerGlobalReceiver(Identifier channelName, PlayChannelHandler channelHandler) {
        return ServerNetworkingImpl.PLAY.registerGlobalReceiver(channelName, channelHandler);
    }

    public static <T extends FabricPacket> boolean registerGlobalReceiver(final PacketType<T> type, final PlayPacketHandler<T> handler) {
        return ServerPlayNetworking.registerGlobalReceiver(type.getId(), new PlayChannelHandlerProxy<T>(){

            @Override
            public PlayPacketHandler<T> getOriginalHandler() {
                return handler;
            }

            @Override
            public void receive(MinecraftServer server, ServerPlayerEntity player, ServerPlayNetworkHandler networkHandler, PacketByteBuf buf, PacketSender sender) {
                Object packet = type.read(buf);
                if (server.isOnThread()) {
                    handler.receive(packet, player, sender);
                } else {
                    server.execute(() -> {
                        if (networkHandler.isConnectionOpen()) {
                            handler.receive(packet, player, sender);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public static PlayChannelHandler unregisterGlobalReceiver(Identifier channelName) {
        return ServerNetworkingImpl.PLAY.unregisterGlobalReceiver(channelName);
    }

    @Nullable
    public static <T extends FabricPacket> PlayPacketHandler<T> unregisterGlobalReceiver(PacketType<T> type) {
        PlayPacketHandler playPacketHandler;
        PlayChannelHandler handler = ServerNetworkingImpl.PLAY.unregisterGlobalReceiver(type.getId());
        if (handler instanceof PlayChannelHandlerProxy) {
            PlayChannelHandlerProxy proxy = (PlayChannelHandlerProxy)handler;
            playPacketHandler = proxy.getOriginalHandler();
        } else {
            playPacketHandler = null;
        }
        return playPacketHandler;
    }

    public static Set<Identifier> getGlobalReceivers() {
        return ServerNetworkingImpl.PLAY.getChannels();
    }

    public static boolean registerReceiver(ServerPlayNetworkHandler networkHandler, Identifier channelName, PlayChannelHandler channelHandler) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(channelName, channelHandler);
    }

    public static <T extends FabricPacket> boolean registerReceiver(ServerPlayNetworkHandler networkHandler, final PacketType<T> type, final PlayPacketHandler<T> handler) {
        return ServerPlayNetworking.registerReceiver(networkHandler, type.getId(), new PlayChannelHandlerProxy<T>(){

            @Override
            public PlayPacketHandler<T> getOriginalHandler() {
                return handler;
            }

            @Override
            public void receive(MinecraftServer server, ServerPlayerEntity player, ServerPlayNetworkHandler networkHandler2, PacketByteBuf buf, PacketSender sender) {
                Object packet = type.read(buf);
                if (server.isOnThread()) {
                    handler.receive(packet, player, sender);
                } else {
                    server.execute(() -> {
                        if (networkHandler2.isConnectionOpen()) {
                            handler.receive(packet, player, sender);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public static PlayChannelHandler unregisterReceiver(ServerPlayNetworkHandler networkHandler, Identifier channelName) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return (PlayChannelHandler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(channelName);
    }

    @Nullable
    public static <T extends FabricPacket> PlayPacketHandler<T> unregisterReceiver(ServerPlayNetworkHandler networkHandler, PacketType<T> type) {
        PlayPacketHandler playPacketHandler;
        PlayChannelHandler handler = ServerPlayNetworking.unregisterReceiver(networkHandler, type.getId());
        if (handler instanceof PlayChannelHandlerProxy) {
            PlayChannelHandlerProxy proxy = (PlayChannelHandlerProxy)handler;
            playPacketHandler = proxy.getOriginalHandler();
        } else {
            playPacketHandler = null;
        }
        return playPacketHandler;
    }

    public static Set<Identifier> getReceived(ServerPlayerEntity player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getReceived(player.networkHandler);
    }

    public static Set<Identifier> getReceived(ServerPlayNetworkHandler handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getReceivableChannels();
    }

    public static Set<Identifier> getSendable(ServerPlayerEntity player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSendable(player.networkHandler);
    }

    public static Set<Identifier> getSendable(ServerPlayNetworkHandler handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels();
    }

    public static boolean canSend(ServerPlayerEntity player, Identifier channelName) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.canSend(player.networkHandler, channelName);
    }

    public static boolean canSend(ServerPlayerEntity player, PacketType<?> type) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.canSend(player.networkHandler, type.getId());
    }

    public static boolean canSend(ServerPlayNetworkHandler handler, Identifier channelName) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(channelName);
    }

    public static boolean canSend(ServerPlayNetworkHandler handler, PacketType<?> type) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        Objects.requireNonNull(type, "Packet type cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(type.getId());
    }

    public static Packet<ClientPlayPacketListener> createS2CPacket(Identifier channelName, PacketByteBuf buf) {
        Objects.requireNonNull(channelName, "Channel cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ServerNetworkingImpl.createPlayC2SPacket(channelName, buf);
    }

    public static PacketSender getSender(ServerPlayerEntity player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSender(player.networkHandler);
    }

    public static PacketSender getSender(ServerPlayNetworkHandler handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler);
    }

    public static void send(ServerPlayerEntity player, Identifier channelName, PacketByteBuf buf) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Packet byte buf cannot be null");
        player.networkHandler.sendPacket(ServerPlayNetworking.createS2CPacket(channelName, buf));
    }

    public static <T extends FabricPacket> void send(ServerPlayerEntity player, T packet) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        PacketByteBuf buf = PacketByteBufs.create();
        packet.write(buf);
        player.networkHandler.sendPacket(ServerPlayNetworking.createS2CPacket(packet.getType().getId(), buf));
    }

    public static MinecraftServer getServer(ServerPlayNetworkHandler handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return handler.player.server;
    }

    private ServerPlayNetworking() {
    }

    @FunctionalInterface
    public static interface PlayPacketHandler<T extends FabricPacket> {
        public void receive(T var1, ServerPlayerEntity var2, PacketSender var3);
    }

    @FunctionalInterface
    public static interface PlayChannelHandler {
        public void receive(MinecraftServer var1, ServerPlayerEntity var2, ServerPlayNetworkHandler var3, PacketByteBuf var4, PacketSender var5);
    }

    private static interface PlayChannelHandlerProxy<T extends FabricPacket>
    extends PlayChannelHandler {
        public PlayPacketHandler<T> getOriginalHandler();
    }
}

