/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.util.Identifier;

public final class PacketType<T extends FabricPacket> {
    private final Identifier id;
    private final Function<PacketByteBuf, T> constructor;

    private PacketType(Identifier id, Function<PacketByteBuf, T> constructor) {
        this.id = id;
        this.constructor = constructor;
    }

    public static <P extends FabricPacket> PacketType<P> create(Identifier id, Function<PacketByteBuf, P> constructor) {
        return new PacketType<P>(id, constructor);
    }

    public Identifier getId() {
        return this.id;
    }

    public T read(PacketByteBuf buf) {
        try {
            return (T)((FabricPacket)this.constructor.apply(buf));
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error while handling packet \"%s\": %s".formatted(this.id, e.getMessage()), e);
        }
    }
}

