/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.content.registry;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.registry.Registries;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.registry.tag.TagKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FuelRegistryImpl
implements FuelRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(FuelRegistryImpl.class);
    private final Object2IntMap<ItemConvertible> itemCookTimes = new Object2IntLinkedOpenHashMap();
    private final Object2IntMap<TagKey<Item>> tagCookTimes = new Object2IntLinkedOpenHashMap();
    private volatile Map<Item, Integer> fuelTimeCache = null;

    public FuelRegistryImpl() {
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> this.resetCache());
    }

    public Map<Item, Integer> getFuelTimes() {
        Map<Item, Integer> ret = this.fuelTimeCache;
        if (ret == null) {
            this.fuelTimeCache = ret = new IdentityHashMap<Item, Integer>(AbstractFurnaceBlockEntity.createFuelTimeMap());
        }
        return ret;
    }

    @Override
    public Integer get(ItemConvertible item) {
        return this.getFuelTimes().get(item.asItem());
    }

    @Override
    public void add(ItemConvertible item, Integer cookTime) {
        if (cookTime > Short.MAX_VALUE) {
            LOGGER.warn("Tried to register an overly high cookTime: " + cookTime + " > 32767! (" + String.valueOf(item) + ")");
        }
        this.itemCookTimes.put((Object)item, cookTime.intValue());
        this.resetCache();
    }

    @Override
    public void add(TagKey<Item> tag, Integer cookTime) {
        if (cookTime > Short.MAX_VALUE) {
            LOGGER.warn("Tried to register an overly high cookTime: " + cookTime + " > 32767! (" + FuelRegistryImpl.getTagName(tag) + ")");
        }
        this.tagCookTimes.put(tag, cookTime.intValue());
        this.resetCache();
    }

    @Override
    public void remove(ItemConvertible item) {
        this.add(item, (Integer)0);
        this.resetCache();
    }

    @Override
    public void remove(TagKey<Item> tag) {
        this.add(tag, (Integer)0);
        this.resetCache();
    }

    @Override
    public void clear(ItemConvertible item) {
        this.itemCookTimes.removeInt((Object)item);
        this.resetCache();
    }

    @Override
    public void clear(TagKey<Item> tag) {
        this.tagCookTimes.removeInt(tag);
        this.resetCache();
    }

    public void apply(Map<Item, Integer> map) {
        int time;
        for (TagKey tag : this.tagCookTimes.keySet()) {
            time = this.tagCookTimes.getInt((Object)tag);
            if (time <= 0) {
                for (RegistryEntry key : Registries.ITEM.iterateEntries(tag)) {
                    Item item = (Item)key.value();
                    map.remove(item);
                }
                continue;
            }
            AbstractFurnaceBlockEntity.addFuel(map, (TagKey)tag, (int)time);
        }
        for (ItemConvertible item : this.itemCookTimes.keySet()) {
            time = this.itemCookTimes.getInt((Object)item);
            if (time <= 0) {
                map.remove(item.asItem());
                continue;
            }
            AbstractFurnaceBlockEntity.addFuel(map, (ItemConvertible)item, (int)time);
        }
    }

    private static String getTagName(TagKey<?> tag) {
        return tag.id().toString();
    }

    public void resetCache() {
        this.fuelTimeCache = null;
    }
}

