/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.event.lifecycle.server;

import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.WorldChunk;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={WorldChunk.class})
abstract class WorldChunkMixin {
    WorldChunkMixin() {
    }

    @Shadow
    public abstract World method_12200();

    @Inject(method={"setBlockEntity"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.BY, by=3)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void onLoadBlockEntity(BlockEntity blockEntity, CallbackInfo ci, BlockPos blockPos, @Nullable BlockEntity removedBlockEntity) {
        if (blockEntity != null && blockEntity != removedBlockEntity && this.method_12200() instanceof ServerWorld) {
            ((ServerBlockEntityEvents.Load)ServerBlockEntityEvents.BLOCK_ENTITY_LOAD.invoker()).onLoad(blockEntity, (ServerWorld)this.method_12200());
        }
    }

    @Inject(method={"setBlockEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/entity/BlockEntity;markRemoved()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void onRemoveBlockEntity(BlockEntity blockEntity, CallbackInfo info, BlockPos blockPos, @Nullable BlockEntity removedBlockEntity) {
        if (removedBlockEntity != null && this.method_12200() instanceof ServerWorld) {
            ((ServerBlockEntityEvents.Unload)ServerBlockEntityEvents.BLOCK_ENTITY_UNLOAD.invoker()).onUnload(removedBlockEntity, (ServerWorld)this.method_12200());
        }
    }

    @Redirect(method={"getBlockEntity(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/WorldChunk$CreationType;)Lnet/minecraft/block/entity/BlockEntity;"}, at=@At(value="INVOKE", target="Ljava/util/Map;remove(Ljava/lang/Object;)Ljava/lang/Object;"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/WorldChunk;createBlockEntity(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/entity/BlockEntity;")))
    private <K, V> Object onRemoveBlockEntity(Map<K, V> map, K key) {
        @Nullable V removed = map.remove(key);
        if (removed != null && this.method_12200() instanceof ServerWorld) {
            ((ServerBlockEntityEvents.Unload)ServerBlockEntityEvents.BLOCK_ENTITY_UNLOAD.invoker()).onUnload((BlockEntity)removed, (ServerWorld)this.method_12200());
        }
        return removed;
    }

    @Inject(method={"removeBlockEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/entity/BlockEntity;markRemoved()V")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void onRemoveBlockEntity(BlockPos pos, CallbackInfo ci, @Nullable BlockEntity removed) {
        if (removed != null && this.method_12200() instanceof ServerWorld) {
            ((ServerBlockEntityEvents.Unload)ServerBlockEntityEvents.BLOCK_ENTITY_UNLOAD.invoker()).onUnload(removed, (ServerWorld)this.method_12200());
        }
    }
}

