/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient;

import io.netty.channel.ChannelHandler;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientImpl;
import net.fabricmc.fabric.impl.recipe.ingredient.SupportedIngredientsPacketEncoder;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

public class CustomIngredientSync
implements ModInitializer {
    public static final Identifier PACKET_ID = new Identifier("fabric", "custom_ingredient_sync");
    public static final int PROTOCOL_VERSION_1 = 1;
    public static final ThreadLocal<Set<Identifier>> CURRENT_SUPPORTED_INGREDIENTS = new ThreadLocal();

    @Nullable
    public static PacketByteBuf createResponsePacket(int serverProtocolVersion) {
        if (serverProtocolVersion < 1) {
            return null;
        }
        PacketByteBuf buf = PacketByteBufs.create();
        buf.writeVarInt(1);
        buf.writeCollection(CustomIngredientImpl.REGISTERED_SERIALIZERS.keySet(), PacketByteBuf::writeIdentifier);
        return buf;
    }

    public static Set<Identifier> decodeResponsePacket(PacketByteBuf buf) {
        int protocolVersion = buf.readVarInt();
        switch (protocolVersion) {
            case 1: {
                Set identifiers = (Set)buf.readCollection(HashSet::new, PacketByteBuf::readIdentifier);
                identifiers.removeIf(id -> !CustomIngredientImpl.REGISTERED_SERIALIZERS.containsKey(id));
                return identifiers;
            }
        }
        throw new IllegalArgumentException("Unknown ingredient sync protocol version: " + protocolVersion);
    }

    public void onInitialize() {
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> {
            PacketByteBuf buf = PacketByteBufs.create();
            buf.writeVarInt(1);
            sender.sendPacket(PACKET_ID, buf);
        });
        ServerLoginNetworking.registerGlobalReceiver((Identifier)PACKET_ID, (server, handler, understood, buf, synchronizer, responseSender) -> {
            if (!understood) {
                return;
            }
            Set<Identifier> supportedCustomIngredients = CustomIngredientSync.decodeResponsePacket(buf);
            ChannelHandler packetEncoder = handler.connection.channel.pipeline().get("encoder");
            if (packetEncoder != null) {
                ((SupportedIngredientsPacketEncoder)packetEncoder).fabric_setSupportedCustomIngredients(supportedCustomIngredients);
            }
        });
    }
}

