/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.registry.Registerable;
import net.minecraft.registry.RegistryEntryLookup;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.structure.pool.StructurePool;
import net.minecraft.structure.pool.StructurePoolElement;
import net.minecraft.structure.pool.StructurePools;
import net.minecraft.structure.processor.StructureProcessorList;
import net.minecraft.structure.processor.StructureProcessorLists;
import net.minecraft.world.gen.feature.PlacedFeature;
import net.minecraft.world.gen.feature.VillagePlacedFeatures;

public class SavannaVillageData {
    public static final RegistryKey<StructurePool> TOWN_CENTERS_KEY = StructurePools.of("village/savanna/town_centers");
    private static final RegistryKey<StructurePool> TERMINATORS_KEY = StructurePools.of("village/savanna/terminators");
    private static final RegistryKey<StructurePool> ZOMBIE_TERMINATORS_KEY = StructurePools.of("village/savanna/zombie/terminators");

    public static void bootstrap(Registerable<StructurePool> poolRegisterable) {
        RegistryEntryLookup<PlacedFeature> registryEntryLookup = poolRegisterable.getRegistryLookup(RegistryKeys.PLACED_FEATURE);
        RegistryEntry.Reference<PlacedFeature> registryEntry = registryEntryLookup.getOrThrow(VillagePlacedFeatures.ACACIA);
        RegistryEntry.Reference<PlacedFeature> registryEntry2 = registryEntryLookup.getOrThrow(VillagePlacedFeatures.PILE_HAY);
        RegistryEntry.Reference<PlacedFeature> registryEntry3 = registryEntryLookup.getOrThrow(VillagePlacedFeatures.PILE_MELON);
        RegistryEntryLookup<StructureProcessorList> registryEntryLookup2 = poolRegisterable.getRegistryLookup(RegistryKeys.PROCESSOR_LIST);
        RegistryEntry.Reference<StructureProcessorList> registryEntry4 = registryEntryLookup2.getOrThrow(StructureProcessorLists.ZOMBIE_SAVANNA);
        RegistryEntry.Reference<StructureProcessorList> registryEntry5 = registryEntryLookup2.getOrThrow(StructureProcessorLists.STREET_SAVANNA);
        RegistryEntry.Reference<StructureProcessorList> registryEntry6 = registryEntryLookup2.getOrThrow(StructureProcessorLists.FARM_SAVANNA);
        RegistryEntryLookup<StructurePool> registryEntryLookup3 = poolRegisterable.getRegistryLookup(RegistryKeys.TEMPLATE_POOL);
        RegistryEntry.Reference<StructurePool> registryEntry7 = registryEntryLookup3.getOrThrow(StructurePools.EMPTY);
        RegistryEntry.Reference<StructurePool> registryEntry8 = registryEntryLookup3.getOrThrow(TERMINATORS_KEY);
        RegistryEntry.Reference<StructurePool> registryEntry9 = registryEntryLookup3.getOrThrow(ZOMBIE_TERMINATORS_KEY);
        poolRegisterable.register(TOWN_CENTERS_KEY, new StructurePool(registryEntry7, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/town_centers/savanna_meeting_point_1"), (Object)100), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/town_centers/savanna_meeting_point_2"), (Object)50), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/town_centers/savanna_meeting_point_3"), (Object)150), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/town_centers/savanna_meeting_point_4"), (Object)150), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/town_centers/savanna_meeting_point_1", registryEntry4), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/town_centers/savanna_meeting_point_2", registryEntry4), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/town_centers/savanna_meeting_point_3", registryEntry4), (Object)3), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/town_centers/savanna_meeting_point_4", registryEntry4), (Object)3)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "village/savanna/streets", new StructurePool(registryEntry8, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/corner_01", registryEntry5), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/corner_03", registryEntry5), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/straight_02", registryEntry5), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/straight_04", registryEntry5), (Object)7), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/straight_05", registryEntry5), (Object)3), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/straight_06", registryEntry5), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/straight_08", registryEntry5), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/straight_09", registryEntry5), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/straight_10", registryEntry5), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/straight_11", registryEntry5), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/crossroad_02", registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/crossroad_03", registryEntry5), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/crossroad_04", registryEntry5), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/crossroad_05", registryEntry5), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/crossroad_06", registryEntry5), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/crossroad_07", registryEntry5), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/split_01", registryEntry5), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/split_02", registryEntry5), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/streets/turn_01", registryEntry5), (Object)3)}), StructurePool.Projection.TERRAIN_MATCHING));
        StructurePools.register(poolRegisterable, "village/savanna/zombie/streets", new StructurePool(registryEntry9, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/corner_01", registryEntry5), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/corner_03", registryEntry5), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/straight_02", registryEntry5), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/straight_04", registryEntry5), (Object)7), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/straight_05", registryEntry5), (Object)3), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/straight_06", registryEntry5), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/straight_08", registryEntry5), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/straight_09", registryEntry5), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/straight_10", registryEntry5), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/straight_11", registryEntry5), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/crossroad_02", registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/crossroad_03", registryEntry5), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/crossroad_04", registryEntry5), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/crossroad_05", registryEntry5), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/crossroad_06", registryEntry5), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/crossroad_07", registryEntry5), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/split_01", registryEntry5), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/split_02", registryEntry5), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/streets/turn_01", registryEntry5), (Object)3)}), StructurePool.Projection.TERRAIN_MATCHING));
        StructurePools.register(poolRegisterable, "village/savanna/houses", new StructurePool(registryEntry8, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_small_house_1"), (Object)2), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_small_house_2"), (Object)2), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_small_house_3"), (Object)2), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_small_house_4"), (Object)2), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_small_house_5"), (Object)2), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_small_house_6"), (Object)2), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_small_house_7"), (Object)2), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_small_house_8"), (Object)2), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_medium_house_1"), (Object)2), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_medium_house_2"), (Object)2), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_butchers_shop_1"), (Object)2), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_butchers_shop_2"), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_tool_smith_1"), (Object)2), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_fletcher_house_1"), (Object)2), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_shepherd_1"), (Object)7), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_armorer_1"), (Object)1), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_fisher_cottage_1"), (Object)3), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_tannery_1"), (Object)2), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_cartographer_1"), (Object)2), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_library_1"), (Object)2), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_mason_1"), (Object)2), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_weaponsmith_1"), (Object)2), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_weaponsmith_2"), (Object)2), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_temple_1"), (Object)2), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_temple_2"), (Object)3), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_large_farm_1", registryEntry6), (Object)4), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_large_farm_2", registryEntry6), (Object)6), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_small_farm", registryEntry6), (Object)4), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_animal_pen_1"), (Object)2), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_animal_pen_2"), (Object)2), Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/houses/savanna_animal_pen_3"), (Object)2), Pair.of(StructurePoolElement.ofEmpty(), (Object)5)}), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "village/savanna/zombie/houses", new StructurePool(registryEntry9, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_small_house_1", registryEntry4), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_small_house_2", registryEntry4), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_small_house_3", registryEntry4), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_small_house_4", registryEntry4), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_small_house_5", registryEntry4), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_small_house_6", registryEntry4), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_small_house_7", registryEntry4), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_small_house_8", registryEntry4), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_medium_house_1", registryEntry4), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_medium_house_2", registryEntry4), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_butchers_shop_1", registryEntry4), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_butchers_shop_2", registryEntry4), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_tool_smith_1", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_fletcher_house_1", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_shepherd_1", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_armorer_1", registryEntry4), (Object)1), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_fisher_cottage_1", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_tannery_1", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_cartographer_1", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_library_1", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_mason_1", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_weaponsmith_1", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_weaponsmith_2", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_temple_1", registryEntry4), (Object)1), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_temple_2", registryEntry4), (Object)3), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_large_farm_1", registryEntry4), (Object)4), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_large_farm_2", registryEntry4), (Object)4), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_small_farm", registryEntry4), (Object)4), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/houses/savanna_animal_pen_1", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_animal_pen_2", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/houses/savanna_animal_pen_3", registryEntry4), (Object)2), Pair.of(StructurePoolElement.ofEmpty(), (Object)5)}), StructurePool.Projection.RIGID));
        poolRegisterable.register(TERMINATORS_KEY, new StructurePool(registryEntry7, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/plains/terminators/terminator_01", registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/plains/terminators/terminator_02", registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/plains/terminators/terminator_03", registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/plains/terminators/terminator_04", registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/terminators/terminator_05", registryEntry5), (Object)1)), StructurePool.Projection.TERRAIN_MATCHING));
        poolRegisterable.register(ZOMBIE_TERMINATORS_KEY, new StructurePool(registryEntry7, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/plains/terminators/terminator_01", registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/plains/terminators/terminator_02", registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/plains/terminators/terminator_03", registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/plains/terminators/terminator_04", registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/zombie/terminators/terminator_05", registryEntry5), (Object)1)), StructurePool.Projection.TERRAIN_MATCHING));
        StructurePools.register(poolRegisterable, "village/savanna/trees", new StructurePool(registryEntry7, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofFeature(registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "village/savanna/decor", new StructurePool(registryEntry7, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/savanna_lamp_post_01"), (Object)4), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry), (Object)4), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry2), (Object)4), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry3), (Object)1), (Object)Pair.of(StructurePoolElement.ofEmpty(), (Object)4)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "village/savanna/zombie/decor", new StructurePool(registryEntry7, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/savanna/savanna_lamp_post_01", registryEntry4), (Object)4), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry), (Object)4), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry2), (Object)4), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry3), (Object)1), (Object)Pair.of(StructurePoolElement.ofEmpty(), (Object)4)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "village/savanna/villagers", new StructurePool(registryEntry7, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/villagers/nitwit"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/villagers/baby"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/villagers/unemployed"), (Object)10)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "village/savanna/zombie/villagers", new StructurePool(registryEntry7, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/zombie/villagers/nitwit"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/savanna/zombie/villagers/unemployed"), (Object)10)), StructurePool.Projection.RIGID));
    }
}

