/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.registry.Registerable;
import net.minecraft.registry.RegistryEntryLookup;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.structure.pool.StructurePool;
import net.minecraft.structure.pool.StructurePoolElement;
import net.minecraft.structure.pool.StructurePools;
import net.minecraft.structure.processor.StructureProcessorList;
import net.minecraft.structure.processor.StructureProcessorLists;

public class BastionTreasureData {
    public static void bootstrap(Registerable<StructurePool> poolRegisterable) {
        RegistryEntryLookup<StructureProcessorList> registryEntryLookup = poolRegisterable.getRegistryLookup(RegistryKeys.PROCESSOR_LIST);
        RegistryEntry.Reference<StructureProcessorList> registryEntry = registryEntryLookup.getOrThrow(StructureProcessorLists.TREASURE_ROOMS);
        RegistryEntry.Reference<StructureProcessorList> registryEntry2 = registryEntryLookup.getOrThrow(StructureProcessorLists.HIGH_WALL);
        RegistryEntry.Reference<StructureProcessorList> registryEntry3 = registryEntryLookup.getOrThrow(StructureProcessorLists.BOTTOM_RAMPART);
        RegistryEntry.Reference<StructureProcessorList> registryEntry4 = registryEntryLookup.getOrThrow(StructureProcessorLists.HIGH_RAMPART);
        RegistryEntry.Reference<StructureProcessorList> registryEntry5 = registryEntryLookup.getOrThrow(StructureProcessorLists.ROOF);
        RegistryEntryLookup<StructurePool> registryEntryLookup2 = poolRegisterable.getRegistryLookup(RegistryKeys.TEMPLATE_POOL);
        RegistryEntry.Reference<StructurePool> registryEntry6 = registryEntryLookup2.getOrThrow(StructurePools.EMPTY);
        StructurePools.register(poolRegisterable, "bastion/treasure/bases", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/bases/lava_basin", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/stairs", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/stairs/lower_stairs", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/bases/centers", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/bases/centers/center_0", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/bases/centers/center_1", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/bases/centers/center_2", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/bases/centers/center_3", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/brains", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/brains/center_brain", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/walls", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/lava_wall", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/entrance_wall", registryEntry2), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/walls/outer", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/outer/top_corner", registryEntry2), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/outer/mid_corner", registryEntry2), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/outer/bottom_corner", registryEntry2), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/outer/outer_wall", registryEntry2), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/outer/medium_outer_wall", registryEntry2), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/outer/tall_outer_wall", registryEntry2), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/walls/bottom", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/bottom/wall_0", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/bottom/wall_1", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/bottom/wall_2", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/bottom/wall_3", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/walls/mid", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/mid/wall_0", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/mid/wall_1", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/mid/wall_2", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/walls/top", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/top/main_entrance", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/top/wall_0", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/walls/top/wall_1", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/connectors", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/connectors/center_to_wall_middle", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/connectors/center_to_wall_top", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/connectors/center_to_wall_top_entrance", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/entrances", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/entrances/entrance_0", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/ramparts", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/ramparts/mid_wall_main", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/ramparts/mid_wall_side", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/ramparts/bottom_wall_0", registryEntry3), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/ramparts/top_wall", registryEntry4), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/ramparts/lava_basin_side", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/ramparts/lava_basin_main", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/corners/bottom", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/corners/bottom/corner_0", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/corners/bottom/corner_1", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/corners/edges", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/corners/edges/bottom", registryEntry2), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/corners/edges/middle", registryEntry2), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/corners/edges/top", registryEntry2), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/corners/middle", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/corners/middle/corner_0", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/corners/middle/corner_1", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/corners/top", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/corners/top/corner_0", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/corners/top/corner_1", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/extensions/large_pool", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/empty", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/empty", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/fire_room", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/large_bridge_0", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/large_bridge_1", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/large_bridge_2", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/large_bridge_3", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/roofed_bridge", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/empty", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/extensions/small_pool", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/empty", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/fire_room", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/empty", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/small_bridge_0", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/small_bridge_1", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/small_bridge_2", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/small_bridge_3", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/extensions/houses", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/house_0", registryEntry), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/extensions/house_1", registryEntry), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "bastion/treasure/roofs", new StructurePool(registryEntry6, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/roofs/wall_roof", registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/roofs/corner_roof", registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedSingle("bastion/treasure/roofs/center_roof", registryEntry5), (Object)1)), StructurePool.Projection.RIGID));
    }
}

