/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.context;

import com.google.common.collect.Sets;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootDataLookup;
import net.minecraft.loot.LootDataType;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.condition.LootCondition;
import net.minecraft.loot.context.LootContextParameter;
import net.minecraft.loot.context.LootContextParameterSet;
import net.minecraft.loot.context.LootContextParameters;
import net.minecraft.loot.function.LootFunction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.random.Random;
import org.jetbrains.annotations.Nullable;

public class LootContext {
    private final LootContextParameterSet parameters;
    private final Random random;
    private final LootDataLookup dataLookup;
    private final Set<Entry<?>> activeEntries = Sets.newLinkedHashSet();

    LootContext(LootContextParameterSet parameters, Random random, LootDataLookup dataLookup) {
        this.parameters = parameters;
        this.random = random;
        this.dataLookup = dataLookup;
    }

    public boolean hasParameter(LootContextParameter<?> parameter) {
        return this.parameters.contains(parameter);
    }

    public <T> T requireParameter(LootContextParameter<T> parameter) {
        return this.parameters.get(parameter);
    }

    public void drop(Identifier id, Consumer<ItemStack> lootConsumer) {
        this.parameters.addDynamicDrops(id, lootConsumer);
    }

    @Nullable
    public <T> T get(LootContextParameter<T> parameter) {
        return this.parameters.getOptional(parameter);
    }

    public boolean isActive(Entry<?> entry) {
        return this.activeEntries.contains(entry);
    }

    public boolean markActive(Entry<?> entry) {
        return this.activeEntries.add(entry);
    }

    public void markInactive(Entry<?> entry) {
        this.activeEntries.remove(entry);
    }

    public LootDataLookup getDataLookup() {
        return this.dataLookup;
    }

    public Random getRandom() {
        return this.random;
    }

    public float getLuck() {
        return this.parameters.getLuck();
    }

    public ServerWorld getWorld() {
        return this.parameters.getWorld();
    }

    public static Entry<LootTable> table(LootTable table) {
        return new Entry<LootTable>(LootDataType.LOOT_TABLES, table);
    }

    public static Entry<LootCondition> predicate(LootCondition predicate) {
        return new Entry<LootCondition>(LootDataType.PREDICATES, predicate);
    }

    public static Entry<LootFunction> itemModifier(LootFunction itemModifier) {
        return new Entry<LootFunction>(LootDataType.ITEM_MODIFIERS, itemModifier);
    }

    public record Entry<T>(LootDataType<T> type, T value) {
    }

    public static final class EntityTarget
    extends Enum<EntityTarget> {
        public static final /* enum */ EntityTarget THIS = new EntityTarget("this", LootContextParameters.THIS_ENTITY);
        public static final /* enum */ EntityTarget KILLER = new EntityTarget("killer", LootContextParameters.KILLER_ENTITY);
        public static final /* enum */ EntityTarget DIRECT_KILLER = new EntityTarget("direct_killer", LootContextParameters.DIRECT_KILLER_ENTITY);
        public static final /* enum */ EntityTarget KILLER_PLAYER = new EntityTarget("killer_player", LootContextParameters.LAST_DAMAGE_PLAYER);
        final String type;
        private final LootContextParameter<? extends Entity> parameter;
        private static final /* synthetic */ EntityTarget[] field_940;

        public static EntityTarget[] values() {
            return (EntityTarget[])field_940.clone();
        }

        public static EntityTarget valueOf(String string) {
            return Enum.valueOf(EntityTarget.class, string);
        }

        private EntityTarget(String type, LootContextParameter<? extends Entity> parameter) {
            this.type = type;
            this.parameter = parameter;
        }

        public LootContextParameter<? extends Entity> getParameter() {
            return this.parameter;
        }

        public static EntityTarget fromString(String type) {
            for (EntityTarget entityTarget : EntityTarget.values()) {
                if (!entityTarget.type.equals(type)) continue;
                return entityTarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + type);
        }

        private static /* synthetic */ EntityTarget[] method_36793() {
            return new EntityTarget[]{THIS, KILLER, DIRECT_KILLER, KILLER_PLAYER};
        }

        static {
            field_940 = EntityTarget.method_36793();
        }

        public static class Serializer
        extends TypeAdapter<EntityTarget> {
            public void write(JsonWriter jsonWriter, EntityTarget entityTarget) throws IOException {
                jsonWriter.value(entityTarget.type);
            }

            public EntityTarget read(JsonReader jsonReader) throws IOException {
                return EntityTarget.fromString(jsonReader.nextString());
            }

            public /* synthetic */ Object read(JsonReader reader) throws IOException {
                return this.read(reader);
            }

            public /* synthetic */ void write(JsonWriter writer, Object entity) throws IOException {
                this.write(writer, (EntityTarget)((Object)entity));
            }
        }
    }

    public static class Builder {
        private final LootContextParameterSet parameters;
        @Nullable
        private Random random;

        public Builder(LootContextParameterSet parameters) {
            this.parameters = parameters;
        }

        public Builder random(long seed) {
            if (seed != 0L) {
                this.random = Random.create(seed);
            }
            return this;
        }

        public ServerWorld getWorld() {
            return this.parameters.getWorld();
        }

        public LootContext build(@Nullable Identifier randomSequenceId) {
            ServerWorld serverWorld = this.getWorld();
            MinecraftServer minecraftServer = serverWorld.getServer();
            Random random = this.random != null ? this.random : (randomSequenceId != null ? serverWorld.getOrCreateRandom(randomSequenceId) : serverWorld.getRandom());
            return new LootContext(this.parameters, random, minecraftServer.getLootManager());
        }
    }
}

