/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.message.v1;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.network.message.MessageDecorator;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

public final class ServerMessageDecoratorEvent {
    public static final Identifier CONTENT_PHASE = new Identifier("fabric", "content");
    public static final Identifier STYLING_PHASE = new Identifier("fabric", "styling");
    public static final Event<MessageDecorator> EVENT = EventFactory.createWithPhases(MessageDecorator.class, decorators -> (sender, message) -> {
        CompletionStage<Object> future = null;
        for (MessageDecorator decorator : decorators) {
            future = future == null ? decorator.decorate(sender, message).handle((decorated, throwable) -> ServerMessageDecoratorEvent.handle(decorated, throwable, decorator)) : future.thenCompose(decorated -> decorator.decorate(sender, decorated).handle((newlyDecorated, throwable) -> ServerMessageDecoratorEvent.handle(newlyDecorated, throwable, decorator)));
        }
        return future == null ? CompletableFuture.completedFuture(message) : future;
    }, (Identifier[])new Identifier[]{CONTENT_PHASE, Event.DEFAULT_PHASE, STYLING_PHASE});

    private ServerMessageDecoratorEvent() {
    }

    private static <T extends Text> T handle(T decorated, @Nullable Throwable throwable, MessageDecorator decorator) {
        String decoratorName = decorator.getClass().getName();
        if (throwable != null) {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            throw new CompletionException("message decorator %s failed".formatted(decoratorName), throwable);
        }
        return Objects.requireNonNull(decorated, "message decorator %s returned null".formatted(decoratorName));
    }
}

