/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.util.Identifier;

public class RegistryMapSerializer {
    public static final int VERSION = 1;

    public static Map<Identifier, Object2IntMap<Identifier>> fromNbt(NbtCompound nbt) {
        NbtCompound mainNbt = nbt.getCompound("registries");
        LinkedHashMap<Identifier, Object2IntMap<Identifier>> map = new LinkedHashMap<Identifier, Object2IntMap<Identifier>>();
        for (String registryId : mainNbt.getKeys()) {
            Object2IntLinkedOpenHashMap idMap = new Object2IntLinkedOpenHashMap();
            NbtCompound idNbt = mainNbt.getCompound(registryId);
            for (String id : idNbt.getKeys()) {
                idMap.put((Object)new Identifier(id), idNbt.getInt(id));
            }
            map.put(new Identifier(registryId), (Object2IntMap<Identifier>)idMap);
        }
        return map;
    }

    public static NbtCompound toNbt(Map<Identifier, Object2IntMap<Identifier>> map) {
        NbtCompound mainNbt = new NbtCompound();
        map.forEach((registryId, idMap) -> {
            NbtCompound registryNbt = new NbtCompound();
            for (Object2IntMap.Entry idPair : idMap.object2IntEntrySet()) {
                registryNbt.putInt(((Identifier)idPair.getKey()).toString(), idPair.getIntValue());
            }
            mainNbt.put(registryId.toString(), (NbtElement)registryNbt);
        });
        NbtCompound nbt = new NbtCompound();
        nbt.putInt("version", 1);
        nbt.put("registries", (NbtElement)mainNbt);
        return nbt;
    }
}

