/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.registry.DynamicRegistryView;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryRemovedCallback;
import net.minecraft.registry.DynamicRegistryManager;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;

public final class DynamicRegistryViewImpl
implements DynamicRegistryView {
    private final Map<RegistryKey<? extends Registry<?>>, Registry<?>> registries;

    public DynamicRegistryViewImpl(Map<RegistryKey<? extends Registry<?>>, Registry<?>> registries) {
        this.registries = registries;
    }

    @Override
    public DynamicRegistryManager asDynamicRegistryManager() {
        return new DynamicRegistryManager.Immutable(){

            public <T> Optional<Registry<T>> getOptional(RegistryKey<? extends Registry<? extends T>> key) {
                return Optional.ofNullable(DynamicRegistryViewImpl.this.registries.get(key));
            }

            public Stream<DynamicRegistryManager.Entry<?>> streamAllRegistries() {
                return DynamicRegistryViewImpl.this.stream().map(this::entry);
            }

            private <T> DynamicRegistryManager.Entry<T> entry(Registry<T> registry) {
                return new DynamicRegistryManager.Entry(registry.getKey(), registry);
            }

            public DynamicRegistryManager.Immutable toImmutable() {
                return this;
            }
        };
    }

    @Override
    public Stream<Registry<?>> stream() {
        return this.registries.values().stream();
    }

    @Override
    public <T> Optional<Registry<T>> getOptional(RegistryKey<? extends Registry<? extends T>> registryRef) {
        return Optional.ofNullable(this.registries.get(registryRef));
    }

    @Override
    public <T> void registerEntryAdded(RegistryKey<? extends Registry<? extends T>> registryRef, RegistryEntryAddedCallback<T> callback) {
        Registry<?> registry = this.registries.get(registryRef);
        if (registry != null) {
            RegistryEntryAddedCallback.event(registry).register(callback);
        }
    }

    @Override
    public <T> void registerEntryRemoved(RegistryKey<? extends Registry<? extends T>> registryRef, RegistryEntryRemovedCallback<T> callback) {
        Registry<?> registry = this.registries.get(registryRef);
        if (registry != null) {
            RegistryEntryRemovedCallback.event(registry).register(callback);
        }
    }
}

