/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryLoader;
import net.minecraft.registry.SerializableRegistries;
import org.jetbrains.annotations.Unmodifiable;

public final class DynamicRegistriesImpl {
    private static final List<RegistryLoader.Entry<?>> DYNAMIC_REGISTRIES = new ArrayList(RegistryLoader.DYNAMIC_REGISTRIES);
    public static final Set<RegistryKey<?>> FABRIC_DYNAMIC_REGISTRY_KEYS = new HashSet();
    public static final Set<RegistryKey<? extends Registry<?>>> DYNAMIC_REGISTRY_KEYS = new HashSet();
    public static final Set<RegistryKey<? extends Registry<?>>> SKIP_EMPTY_SYNC_REGISTRIES = new HashSet();

    private DynamicRegistriesImpl() {
    }

    public static @Unmodifiable List<// Could not load outer class - annotation placement on inner may be incorrect
    RegistryLoader.Entry<?>> getDynamicRegistries() {
        return List.copyOf(DYNAMIC_REGISTRIES);
    }

    public static <T> void register(RegistryKey<? extends Registry<T>> key, Codec<T> codec) {
        Objects.requireNonNull(key, "Registry key cannot be null");
        Objects.requireNonNull(codec, "Codec cannot be null");
        if (!DYNAMIC_REGISTRY_KEYS.add(key)) {
            throw new IllegalArgumentException("Dynamic registry " + String.valueOf(key) + " has already been registered!");
        }
        RegistryLoader.Entry entry = new RegistryLoader.Entry(key, codec);
        DYNAMIC_REGISTRIES.add(entry);
        FABRIC_DYNAMIC_REGISTRY_KEYS.add(key);
    }

    public static <T> void addSyncedRegistry(RegistryKey<? extends Registry<T>> registryKey, Codec<T> networkCodec, DynamicRegistries.SyncOption ... options) {
        Objects.requireNonNull(registryKey, "Registry key cannot be null");
        Objects.requireNonNull(networkCodec, "Network codec cannot be null");
        Objects.requireNonNull(options, "Options cannot be null");
        if (!(SerializableRegistries.REGISTRIES instanceof HashMap)) {
            SerializableRegistries.REGISTRIES = new HashMap(SerializableRegistries.REGISTRIES);
        }
        SerializableRegistries.REGISTRIES.put(registryKey, new SerializableRegistries.Info(registryKey, networkCodec));
        for (DynamicRegistries.SyncOption option : options) {
            if (option != DynamicRegistries.SyncOption.SKIP_WHEN_EMPTY) continue;
            SKIP_EMPTY_SYNC_REGISTRIES.add(registryKey);
        }
    }

    static {
        for (RegistryLoader.Entry vanillaEntry : RegistryLoader.DYNAMIC_REGISTRIES) {
            DYNAMIC_REGISTRY_KEYS.add(vanillaEntry.key());
        }
    }
}

