/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.event.registry;

import com.mojang.serialization.Lifecycle;
import java.util.EnumSet;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.mixin.registry.sync.RegistriesAccessor;
import net.minecraft.registry.MutableRegistry;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.SimpleDefaultedRegistry;
import net.minecraft.registry.SimpleRegistry;
import net.minecraft.util.Identifier;

public final class FabricRegistryBuilder<T, R extends MutableRegistry<T>> {
    private final R registry;
    private final EnumSet<RegistryAttribute> attributes = EnumSet.noneOf(RegistryAttribute.class);

    public static <T, R extends MutableRegistry<T>> FabricRegistryBuilder<T, R> from(R registry) {
        return new FabricRegistryBuilder<T, R>(registry);
    }

    public static <T> FabricRegistryBuilder<T, SimpleRegistry<T>> createSimple(RegistryKey<Registry<T>> registryKey) {
        return FabricRegistryBuilder.from(new SimpleRegistry(registryKey, Lifecycle.stable(), false));
    }

    public static <T> FabricRegistryBuilder<T, SimpleDefaultedRegistry<T>> createDefaulted(RegistryKey<Registry<T>> registryKey, Identifier defaultId) {
        return FabricRegistryBuilder.from(new SimpleDefaultedRegistry(defaultId.toString(), registryKey, Lifecycle.stable(), false));
    }

    @Deprecated
    public static <T> FabricRegistryBuilder<T, SimpleRegistry<T>> createSimple(Class<T> type, Identifier registryId) {
        return FabricRegistryBuilder.createSimple(RegistryKey.ofRegistry((Identifier)registryId));
    }

    @Deprecated
    public static <T> FabricRegistryBuilder<T, SimpleDefaultedRegistry<T>> createDefaulted(Class<T> type, Identifier registryId, Identifier defaultId) {
        return FabricRegistryBuilder.createDefaulted(RegistryKey.ofRegistry((Identifier)registryId), defaultId);
    }

    private FabricRegistryBuilder(R registry) {
        this.registry = registry;
        this.attribute(RegistryAttribute.MODDED);
    }

    public FabricRegistryBuilder<T, R> attribute(RegistryAttribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public R buildAndRegister() {
        RegistryKey key = this.registry.getKey();
        for (RegistryAttribute attribute : this.attributes) {
            RegistryAttributeHolder.get(key).addAttribute(attribute);
        }
        RegistriesAccessor.getROOT().add(key, this.registry, Lifecycle.stable());
        return this.registry;
    }
}

