/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.villager;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.sound.SoundEvent;
import net.minecraft.util.Identifier;
import net.minecraft.village.VillagerProfession;
import net.minecraft.world.poi.PointOfInterestType;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class VillagerProfessionBuilder {
    private final ImmutableSet.Builder<Item> gatherableItemsBuilder = ImmutableSet.builder();
    private final ImmutableSet.Builder<Block> secondaryJobSiteBlockBuilder = ImmutableSet.builder();
    private Identifier identifier;
    private Predicate<RegistryEntry<PointOfInterestType>> pointOfInterestType;
    private Predicate<RegistryEntry<PointOfInterestType>> acquirableJobSite;
    @Nullable
    private SoundEvent workSoundEvent;

    private VillagerProfessionBuilder() {
    }

    public static VillagerProfessionBuilder create() {
        return new VillagerProfessionBuilder();
    }

    public VillagerProfessionBuilder id(Identifier id) {
        this.identifier = id;
        return this;
    }

    public VillagerProfessionBuilder workstation(RegistryKey<PointOfInterestType> key) {
        this.jobSite(entry -> entry.matchesKey(key));
        return this.workstation((RegistryEntry<PointOfInterestType> entry) -> entry.matchesKey(key));
    }

    public VillagerProfessionBuilder workstation(Predicate<RegistryEntry<PointOfInterestType>> predicate) {
        this.pointOfInterestType = predicate;
        return this;
    }

    public VillagerProfessionBuilder jobSite(Predicate<RegistryEntry<PointOfInterestType>> predicate) {
        this.acquirableJobSite = predicate;
        return this;
    }

    public VillagerProfessionBuilder harvestableItems(Item ... items) {
        this.gatherableItemsBuilder.add((Object[])items);
        return this;
    }

    public VillagerProfessionBuilder harvestableItems(Iterable<Item> items) {
        this.gatherableItemsBuilder.addAll(items);
        return this;
    }

    public VillagerProfessionBuilder secondaryJobSites(Block ... blocks) {
        this.secondaryJobSiteBlockBuilder.add((Object[])blocks);
        return this;
    }

    public VillagerProfessionBuilder secondaryJobSites(Iterable<Block> blocks) {
        this.secondaryJobSiteBlockBuilder.addAll(blocks);
        return this;
    }

    public VillagerProfessionBuilder workSound(@Nullable SoundEvent workSoundEvent) {
        this.workSoundEvent = workSoundEvent;
        return this;
    }

    public VillagerProfession build() {
        Preconditions.checkState((this.identifier != null ? 1 : 0) != 0, (Object)"An Identifier is required to build a new VillagerProfession.");
        Preconditions.checkState((this.pointOfInterestType != null ? 1 : 0) != 0, (Object)"A PointOfInterestType is required to build a new VillagerProfession.");
        Preconditions.checkState((this.acquirableJobSite != null ? 1 : 0) != 0, (Object)"A PointOfInterestType is required for the acquirableJobSite to build a new VillagerProfession.");
        return new VillagerProfession(this.identifier.toString(), this.pointOfInterestType, this.acquirableJobSite, this.gatherableItemsBuilder.build(), this.secondaryJobSiteBlockBuilder.build(), this.workSoundEvent);
    }
}

