/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.entity;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.impl.object.builder.FabricEntityType;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityDimensions;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnGroup;
import net.minecraft.entity.SpawnRestriction;
import net.minecraft.entity.attribute.DefaultAttributeContainer;
import net.minecraft.entity.mob.MobEntity;
import net.minecraft.resource.featuretoggle.FeatureFlag;
import net.minecraft.resource.featuretoggle.FeatureFlags;
import net.minecraft.resource.featuretoggle.FeatureSet;
import net.minecraft.world.Heightmap;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class FabricEntityTypeBuilder<T extends Entity> {
    private SpawnGroup spawnGroup;
    private EntityType.EntityFactory<T> factory;
    private boolean saveable = true;
    private boolean summonable = true;
    private int trackRange = 5;
    private int trackedUpdateRate = 3;
    private Boolean forceTrackedVelocityUpdates;
    private boolean fireImmune = false;
    private boolean spawnableFarFromPlayer;
    private EntityDimensions dimensions = EntityDimensions.changing((float)-1.0f, (float)-1.0f);
    private ImmutableSet<Block> specificSpawnBlocks = ImmutableSet.of();
    private FeatureSet requiredFeatures = FeatureFlags.VANILLA_FEATURES;

    protected FabricEntityTypeBuilder(SpawnGroup spawnGroup, EntityType.EntityFactory<T> factory) {
        this.spawnGroup = spawnGroup;
        this.factory = factory;
        this.spawnableFarFromPlayer = spawnGroup == SpawnGroup.CREATURE || spawnGroup == SpawnGroup.MISC;
    }

    public static <T extends Entity> FabricEntityTypeBuilder<T> create() {
        return FabricEntityTypeBuilder.create(SpawnGroup.MISC);
    }

    public static <T extends Entity> FabricEntityTypeBuilder<T> create(SpawnGroup spawnGroup) {
        return FabricEntityTypeBuilder.create(spawnGroup, FabricEntityTypeBuilder::emptyFactory);
    }

    public static <T extends Entity> FabricEntityTypeBuilder<T> create(SpawnGroup spawnGroup, EntityType.EntityFactory<T> factory) {
        return new FabricEntityTypeBuilder<T>(spawnGroup, factory);
    }

    public static <T extends LivingEntity> Living<T> createLiving() {
        return new Living(SpawnGroup.MISC, FabricEntityTypeBuilder::emptyFactory);
    }

    public static <T extends MobEntity> Mob<T> createMob() {
        return new Mob(SpawnGroup.MISC, FabricEntityTypeBuilder::emptyFactory);
    }

    private static <T extends Entity> T emptyFactory(EntityType<T> type, World world) {
        return null;
    }

    public FabricEntityTypeBuilder<T> spawnGroup(SpawnGroup group) {
        Objects.requireNonNull(group, "Spawn group cannot be null");
        this.spawnGroup = group;
        return this;
    }

    public <N extends T> FabricEntityTypeBuilder<N> entityFactory(EntityType.EntityFactory<N> factory) {
        Objects.requireNonNull(factory, "Entity Factory cannot be null");
        this.factory = factory;
        return this;
    }

    public FabricEntityTypeBuilder<T> disableSummon() {
        this.summonable = false;
        return this;
    }

    public FabricEntityTypeBuilder<T> disableSaving() {
        this.saveable = false;
        return this;
    }

    public FabricEntityTypeBuilder<T> fireImmune() {
        this.fireImmune = true;
        return this;
    }

    public FabricEntityTypeBuilder<T> spawnableFarFromPlayer() {
        this.spawnableFarFromPlayer = true;
        return this;
    }

    public FabricEntityTypeBuilder<T> dimensions(EntityDimensions dimensions) {
        Objects.requireNonNull(dimensions, "Cannot set null dimensions");
        this.dimensions = dimensions;
        return this;
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> trackable(int trackRangeBlocks, int trackedUpdateRate) {
        return this.trackable(trackRangeBlocks, trackedUpdateRate, true);
    }

    @Deprecated
    public FabricEntityTypeBuilder<T> trackable(int trackRangeBlocks, int trackedUpdateRate, boolean forceTrackedVelocityUpdates) {
        this.trackRangeBlocks(trackRangeBlocks);
        this.trackedUpdateRate(trackedUpdateRate);
        this.forceTrackedVelocityUpdates(forceTrackedVelocityUpdates);
        return this;
    }

    public FabricEntityTypeBuilder<T> trackRangeChunks(int range) {
        this.trackRange = range;
        return this;
    }

    public FabricEntityTypeBuilder<T> trackRangeBlocks(int range) {
        return this.trackRangeChunks((range + 15) / 16);
    }

    public FabricEntityTypeBuilder<T> trackedUpdateRate(int rate) {
        this.trackedUpdateRate = rate;
        return this;
    }

    public FabricEntityTypeBuilder<T> forceTrackedVelocityUpdates(boolean forceTrackedVelocityUpdates) {
        this.forceTrackedVelocityUpdates = forceTrackedVelocityUpdates;
        return this;
    }

    public FabricEntityTypeBuilder<T> specificSpawnBlocks(Block ... blocks) {
        this.specificSpawnBlocks = ImmutableSet.copyOf((Object[])blocks);
        return this;
    }

    public FabricEntityTypeBuilder<T> requires(FeatureFlag ... requiredFeatures) {
        this.requiredFeatures = FeatureFlags.FEATURE_MANAGER.featureSetOf(requiredFeatures);
        return this;
    }

    public EntityType<T> build() {
        return new FabricEntityType<T>(this.factory, this.spawnGroup, this.saveable, this.summonable, this.fireImmune, this.spawnableFarFromPlayer, this.specificSpawnBlocks, this.dimensions, this.trackRange, this.trackedUpdateRate, this.forceTrackedVelocityUpdates, this.requiredFeatures);
    }

    public static class Living<T extends LivingEntity>
    extends FabricEntityTypeBuilder<T> {
        @Nullable
        private Supplier<DefaultAttributeContainer.Builder> defaultAttributeBuilder;

        protected Living(SpawnGroup spawnGroup, EntityType.EntityFactory<T> function) {
            super(spawnGroup, function);
        }

        @Override
        public Living<T> spawnGroup(SpawnGroup group) {
            super.spawnGroup(group);
            return this;
        }

        @Override
        public <N extends T> Living<N> entityFactory(EntityType.EntityFactory<N> factory) {
            super.entityFactory(factory);
            return this;
        }

        @Override
        public Living<T> disableSummon() {
            super.disableSummon();
            return this;
        }

        @Override
        public Living<T> disableSaving() {
            super.disableSaving();
            return this;
        }

        @Override
        public Living<T> fireImmune() {
            super.fireImmune();
            return this;
        }

        @Override
        public Living<T> spawnableFarFromPlayer() {
            super.spawnableFarFromPlayer();
            return this;
        }

        @Override
        public Living<T> dimensions(EntityDimensions dimensions) {
            super.dimensions(dimensions);
            return this;
        }

        @Override
        @Deprecated
        public Living<T> trackable(int trackRangeBlocks, int trackedUpdateRate) {
            super.trackable(trackRangeBlocks, trackedUpdateRate);
            return this;
        }

        @Override
        @Deprecated
        public Living<T> trackable(int trackRangeBlocks, int trackedUpdateRate, boolean forceTrackedVelocityUpdates) {
            super.trackable(trackRangeBlocks, trackedUpdateRate, forceTrackedVelocityUpdates);
            return this;
        }

        @Override
        public Living<T> trackRangeChunks(int range) {
            super.trackRangeChunks(range);
            return this;
        }

        @Override
        public Living<T> trackRangeBlocks(int range) {
            super.trackRangeBlocks(range);
            return this;
        }

        @Override
        public Living<T> trackedUpdateRate(int rate) {
            super.trackedUpdateRate(rate);
            return this;
        }

        @Override
        public Living<T> forceTrackedVelocityUpdates(boolean forceTrackedVelocityUpdates) {
            super.forceTrackedVelocityUpdates(forceTrackedVelocityUpdates);
            return this;
        }

        @Override
        public Living<T> specificSpawnBlocks(Block ... blocks) {
            super.specificSpawnBlocks(blocks);
            return this;
        }

        public Living<T> defaultAttributes(Supplier<DefaultAttributeContainer.Builder> defaultAttributeBuilder) {
            Objects.requireNonNull(defaultAttributeBuilder, "Cannot set null attribute builder");
            this.defaultAttributeBuilder = defaultAttributeBuilder;
            return this;
        }

        @Override
        public EntityType<T> build() {
            EntityType type = super.build();
            if (this.defaultAttributeBuilder != null) {
                FabricDefaultAttributeRegistry.register(type, this.defaultAttributeBuilder.get());
            }
            return type;
        }
    }

    public static class Mob<T extends MobEntity>
    extends Living<T> {
        private SpawnRestriction.Location restrictionLocation;
        private Heightmap.Type restrictionHeightmap;
        private SpawnRestriction.SpawnPredicate<T> spawnPredicate;

        protected Mob(SpawnGroup spawnGroup, EntityType.EntityFactory<T> function) {
            super(spawnGroup, function);
        }

        @Override
        public Mob<T> spawnGroup(SpawnGroup group) {
            super.spawnGroup(group);
            return this;
        }

        @Override
        public <N extends T> Mob<N> entityFactory(EntityType.EntityFactory<N> factory) {
            super.entityFactory((EntityType.EntityFactory)factory);
            return this;
        }

        @Override
        public Mob<T> disableSummon() {
            super.disableSummon();
            return this;
        }

        @Override
        public Mob<T> disableSaving() {
            super.disableSaving();
            return this;
        }

        @Override
        public Mob<T> fireImmune() {
            super.fireImmune();
            return this;
        }

        @Override
        public Mob<T> spawnableFarFromPlayer() {
            super.spawnableFarFromPlayer();
            return this;
        }

        @Override
        public Mob<T> dimensions(EntityDimensions dimensions) {
            super.dimensions(dimensions);
            return this;
        }

        @Override
        @Deprecated
        public Mob<T> trackable(int trackRangeBlocks, int trackedUpdateRate) {
            super.trackable(trackRangeBlocks, trackedUpdateRate);
            return this;
        }

        @Override
        @Deprecated
        public Mob<T> trackable(int trackRangeBlocks, int trackedUpdateRate, boolean forceTrackedVelocityUpdates) {
            super.trackable(trackRangeBlocks, trackedUpdateRate, forceTrackedVelocityUpdates);
            return this;
        }

        @Override
        public Mob<T> trackRangeChunks(int range) {
            super.trackRangeChunks(range);
            return this;
        }

        @Override
        public Mob<T> trackRangeBlocks(int range) {
            super.trackRangeBlocks(range);
            return this;
        }

        @Override
        public Mob<T> trackedUpdateRate(int rate) {
            super.trackedUpdateRate(rate);
            return this;
        }

        @Override
        public Mob<T> forceTrackedVelocityUpdates(boolean forceTrackedVelocityUpdates) {
            super.forceTrackedVelocityUpdates(forceTrackedVelocityUpdates);
            return this;
        }

        @Override
        public Mob<T> specificSpawnBlocks(Block ... blocks) {
            super.specificSpawnBlocks(blocks);
            return this;
        }

        @Override
        public Mob<T> defaultAttributes(Supplier<DefaultAttributeContainer.Builder> defaultAttributeBuilder) {
            super.defaultAttributes(defaultAttributeBuilder);
            return this;
        }

        public Mob<T> spawnRestriction(SpawnRestriction.Location location, Heightmap.Type heightmap, SpawnRestriction.SpawnPredicate<T> spawnPredicate) {
            this.restrictionLocation = Objects.requireNonNull(location, "Location cannot be null.");
            this.restrictionHeightmap = Objects.requireNonNull(heightmap, "Heightmap type cannot be null.");
            this.spawnPredicate = Objects.requireNonNull(spawnPredicate, "Spawn predicate cannot be null.");
            return this;
        }

        @Override
        public EntityType<T> build() {
            EntityType type = super.build();
            if (this.spawnPredicate != null) {
                SpawnRestriction.register(type, (SpawnRestriction.Location)this.restrictionLocation, (Heightmap.Type)this.restrictionHeightmap, this.spawnPredicate);
            }
            return type;
        }
    }
}

