/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.block.type;

import net.minecraft.block.BlockSetType;
import net.minecraft.sound.BlockSoundGroup;
import net.minecraft.sound.SoundEvent;
import net.minecraft.sound.SoundEvents;
import net.minecraft.util.Identifier;

public final class BlockSetTypeBuilder {
    private boolean openableByHand = true;
    private BlockSoundGroup soundGroup = BlockSoundGroup.WOOD;
    private SoundEvent doorCloseSound = SoundEvents.BLOCK_WOODEN_DOOR_CLOSE;
    private SoundEvent doorOpenSound = SoundEvents.BLOCK_WOODEN_DOOR_OPEN;
    private SoundEvent trapdoorCloseSound = SoundEvents.BLOCK_WOODEN_TRAPDOOR_CLOSE;
    private SoundEvent trapdoorOpenSound = SoundEvents.BLOCK_WOODEN_TRAPDOOR_OPEN;
    private SoundEvent pressurePlateClickOffSound = SoundEvents.BLOCK_WOODEN_PRESSURE_PLATE_CLICK_OFF;
    private SoundEvent pressurePlateClickOnSound = SoundEvents.BLOCK_WOODEN_PRESSURE_PLATE_CLICK_ON;
    private SoundEvent buttonClickOffSound = SoundEvents.BLOCK_WOODEN_BUTTON_CLICK_OFF;
    private SoundEvent buttonClickOnSound = SoundEvents.BLOCK_WOODEN_BUTTON_CLICK_ON;

    public BlockSetTypeBuilder openableByHand(boolean openableByHand) {
        this.openableByHand = openableByHand;
        return this;
    }

    public BlockSetTypeBuilder soundGroup(BlockSoundGroup soundGroup) {
        this.soundGroup = soundGroup;
        return this;
    }

    public BlockSetTypeBuilder doorCloseSound(SoundEvent doorCloseSound) {
        this.doorCloseSound = doorCloseSound;
        return this;
    }

    public BlockSetTypeBuilder doorOpenSound(SoundEvent doorOpenSound) {
        this.doorOpenSound = doorOpenSound;
        return this;
    }

    public BlockSetTypeBuilder trapdoorCloseSound(SoundEvent trapdoorCloseSound) {
        this.trapdoorCloseSound = trapdoorCloseSound;
        return this;
    }

    public BlockSetTypeBuilder trapdoorOpenSound(SoundEvent trapdoorOpenSound) {
        this.trapdoorOpenSound = trapdoorOpenSound;
        return this;
    }

    public BlockSetTypeBuilder pressurePlateClickOffSound(SoundEvent pressurePlateClickOffSound) {
        this.pressurePlateClickOffSound = pressurePlateClickOffSound;
        return this;
    }

    public BlockSetTypeBuilder pressurePlateClickOnSound(SoundEvent pressurePlateClickOnSound) {
        this.pressurePlateClickOnSound = pressurePlateClickOnSound;
        return this;
    }

    public BlockSetTypeBuilder buttonClickOffSound(SoundEvent buttonClickOffSound) {
        this.buttonClickOffSound = buttonClickOffSound;
        return this;
    }

    public BlockSetTypeBuilder buttonClickOnSound(SoundEvent buttonClickOnSound) {
        this.buttonClickOnSound = buttonClickOnSound;
        return this;
    }

    public static BlockSetTypeBuilder copyOf(BlockSetTypeBuilder builder) {
        BlockSetTypeBuilder copy = new BlockSetTypeBuilder();
        copy.openableByHand(builder.openableByHand);
        copy.soundGroup(builder.soundGroup);
        copy.doorCloseSound(builder.doorCloseSound);
        copy.doorOpenSound(builder.doorOpenSound);
        copy.trapdoorCloseSound(builder.trapdoorCloseSound);
        copy.trapdoorOpenSound(builder.trapdoorOpenSound);
        copy.pressurePlateClickOffSound(builder.pressurePlateClickOffSound);
        copy.pressurePlateClickOnSound(builder.pressurePlateClickOnSound);
        copy.buttonClickOffSound(builder.buttonClickOffSound);
        copy.buttonClickOnSound(builder.buttonClickOnSound);
        return copy;
    }

    public static BlockSetTypeBuilder copyOf(BlockSetType setType) {
        BlockSetTypeBuilder copy = new BlockSetTypeBuilder();
        copy.openableByHand(setType.canOpenByHand());
        copy.soundGroup(setType.soundType());
        copy.doorCloseSound(setType.doorClose());
        copy.doorOpenSound(setType.doorOpen());
        copy.trapdoorCloseSound(setType.trapdoorClose());
        copy.trapdoorOpenSound(setType.trapdoorOpen());
        copy.pressurePlateClickOffSound(setType.pressurePlateClickOff());
        copy.pressurePlateClickOnSound(setType.pressurePlateClickOn());
        copy.buttonClickOffSound(setType.buttonClickOff());
        copy.buttonClickOnSound(setType.buttonClickOn());
        return copy;
    }

    public BlockSetType register(Identifier id) {
        return BlockSetType.register((BlockSetType)this.build(id));
    }

    public BlockSetType build(Identifier id) {
        return new BlockSetType(id.toString(), this.openableByHand, this.soundGroup, this.doorCloseSound, this.doorOpenSound, this.trapdoorCloseSound, this.trapdoorOpenSound, this.pressurePlateClickOffSound, this.pressurePlateClickOnSound, this.buttonClickOffSound, this.buttonClickOnSound);
    }
}

