/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.block.entity;

import com.mojang.datafixers.types.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.block.entity.BlockEntityType;
import net.minecraft.util.math.BlockPos;

public final class FabricBlockEntityTypeBuilder<T extends BlockEntity> {
    private final Factory<? extends T> factory;
    private final List<Block> blocks;

    private FabricBlockEntityTypeBuilder(Factory<? extends T> factory, List<Block> blocks) {
        this.factory = factory;
        this.blocks = blocks;
    }

    public static <T extends BlockEntity> FabricBlockEntityTypeBuilder<T> create(Factory<? extends T> factory, Block ... blocks) {
        ArrayList<Block> blocksList = new ArrayList<Block>(blocks.length);
        Collections.addAll(blocksList, blocks);
        return new FabricBlockEntityTypeBuilder<T>(factory, blocksList);
    }

    public FabricBlockEntityTypeBuilder<T> addBlock(Block block) {
        this.blocks.add(block);
        return this;
    }

    public FabricBlockEntityTypeBuilder<T> addBlocks(Block ... blocks) {
        Collections.addAll(this.blocks, blocks);
        return this;
    }

    public BlockEntityType<T> build() {
        return this.build(null);
    }

    public BlockEntityType<T> build(Type<?> type) {
        return BlockEntityType.Builder.create(this.factory::create, (Block[])this.blocks.toArray(new Block[0])).build(type);
    }

    @FunctionalInterface
    public static interface Factory<T extends BlockEntity> {
        public T create(BlockPos var1, BlockState var2);
    }
}

