/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.item;

import java.util.WeakHashMap;
import net.fabricmc.fabric.api.item.v1.CustomDamageHandler;
import net.fabricmc.fabric.api.item.v1.EquipmentSlotProvider;
import net.fabricmc.fabric.impl.item.ItemExtensions;
import net.minecraft.item.Item;
import org.jetbrains.annotations.Nullable;

public final class FabricItemInternals {
    private static final WeakHashMap<Item.Settings, ExtraData> extraData = new WeakHashMap();

    private FabricItemInternals() {
    }

    public static ExtraData computeExtraData(Item.Settings settings) {
        return extraData.computeIfAbsent(settings, s -> new ExtraData());
    }

    public static void onBuild(Item.Settings settings, Item item) {
        ExtraData data = extraData.get(settings);
        if (data != null) {
            ((ItemExtensions)item).fabric_setEquipmentSlotProvider(data.equipmentSlotProvider);
            ((ItemExtensions)item).fabric_setCustomDamageHandler(data.customDamageHandler);
        }
    }

    public static final class ExtraData {
        @Nullable
        private EquipmentSlotProvider equipmentSlotProvider;
        @Nullable
        private CustomDamageHandler customDamageHandler;

        public void equipmentSlot(EquipmentSlotProvider equipmentSlotProvider) {
            this.equipmentSlotProvider = equipmentSlotProvider;
        }

        public void customDamage(CustomDamageHandler handler) {
            this.customDamageHandler = handler;
        }
    }
}

