/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.registry;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.mixin.content.registry.HoeItemAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemUsageContext;

public final class TillableBlockRegistry {
    private TillableBlockRegistry() {
    }

    public static void register(Block input, Predicate<ItemUsageContext> usagePredicate, Consumer<ItemUsageContext> tillingAction) {
        Objects.requireNonNull(input, "input block cannot be null");
        HoeItemAccessor.getTillingActions().put(input, (Pair<Predicate<ItemUsageContext>, Consumer<ItemUsageContext>>)Pair.of(usagePredicate, tillingAction));
    }

    public static void register(Block input, Predicate<ItemUsageContext> usagePredicate, BlockState tilled) {
        Objects.requireNonNull(tilled, "tilled block state cannot be null");
        TillableBlockRegistry.register(input, usagePredicate, HoeItem.createTillAction((BlockState)tilled));
    }

    public static void register(Block input, Predicate<ItemUsageContext> usagePredicate, BlockState tilled, ItemConvertible droppedItem) {
        Objects.requireNonNull(tilled, "tilled block state cannot be null");
        Objects.requireNonNull(droppedItem, "dropped item cannot be null");
        TillableBlockRegistry.register(input, usagePredicate, HoeItem.createTillAndDropAction((BlockState)tilled, (ItemConvertible)droppedItem));
    }
}

