/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.registry;

import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.impl.content.registry.util.ImmutableCollectionUtils;
import net.fabricmc.fabric.mixin.content.registry.AxeItemAccessor;
import net.minecraft.block.Block;
import net.minecraft.state.property.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StrippableBlockRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrippableBlockRegistry.class);

    private StrippableBlockRegistry() {
    }

    public static void register(Block input, Block stripped) {
        StrippableBlockRegistry.requireNonNullAndAxisProperty(input, "input block");
        StrippableBlockRegistry.requireNonNullAndAxisProperty(stripped, "stripped block");
        Block old = StrippableBlockRegistry.getRegistry().put(input, stripped);
        if (old != null) {
            LOGGER.debug("Replaced old stripping mapping from {} to {} with {}", new Object[]{input, old, stripped});
        }
    }

    private static void requireNonNullAndAxisProperty(Block block, String name) {
        Objects.requireNonNull(block, name + " cannot be null");
        if (!block.getStateManager().getProperties().contains(Properties.AXIS)) {
            throw new IllegalArgumentException(name + " must have the 'axis' property");
        }
    }

    private static Map<Block, Block> getRegistry() {
        return ImmutableCollectionUtils.getAsMutableMap(AxeItemAccessor::getStrippedBlocks, AxeItemAccessor::setStrippedBlocks);
    }
}

