/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.event.lifecycle.v1;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.world.chunk.WorldChunk;

@Environment(value=EnvType.CLIENT)
public final class ClientChunkEvents {
    public static final Event<Load> CHUNK_LOAD = EventFactory.createArrayBacked(Load.class, callbacks -> (clientWorld, chunk) -> {
        for (Load callback : callbacks) {
            callback.onChunkLoad(clientWorld, chunk);
        }
    });
    public static final Event<Unload> CHUNK_UNLOAD = EventFactory.createArrayBacked(Unload.class, callbacks -> (clientWorld, chunk) -> {
        for (Unload callback : callbacks) {
            callback.onChunkUnload(clientWorld, chunk);
        }
    });

    private ClientChunkEvents() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Unload {
        public void onChunkUnload(ClientWorld var1, WorldChunk var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Load {
        public void onChunkLoad(ClientWorld var1, WorldChunk var2);
    }
}

