/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.container;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.container.ContainerFactory;
import net.fabricmc.fabric.api.container.ContainerProviderRegistry;
import net.fabricmc.fabric.impl.container.ServerPlayerEntitySyncHook;
import net.fabricmc.fabric.mixin.container.ServerPlayerEntityAccessor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.s2c.play.CustomPayloadS2CPacket;
import net.minecraft.screen.ScreenHandler;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerProviderImpl
implements ContainerProviderRegistry {
    public static final Identifier OPEN_CONTAINER = new Identifier("fabric", "container/open");
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerProviderImpl.class);
    private static final Map<Identifier, ContainerFactory<ScreenHandler>> FACTORIES = new HashMap<Identifier, ContainerFactory<ScreenHandler>>();
    private boolean emittedNoSyncHookWarning = false;

    @Override
    public void registerFactory(Identifier identifier, ContainerFactory<ScreenHandler> factory) {
        if (FACTORIES.containsKey(identifier)) {
            throw new RuntimeException("A factory has already been registered as " + identifier.toString());
        }
        FACTORIES.put(identifier, factory);
    }

    @Override
    public void openContainer(Identifier identifier, PlayerEntity player, Consumer<PacketByteBuf> writer) {
        if (!(player instanceof ServerPlayerEntity)) {
            LOGGER.warn("Please only use ContainerProviderRegistry.openContainer() with server-sided player entities!");
            return;
        }
        this.openContainer(identifier, (ServerPlayerEntity)player, writer);
    }

    @Override
    public void openContainer(Identifier identifier, ServerPlayerEntity player, Consumer<PacketByteBuf> writer) {
        int syncId;
        if (player instanceof ServerPlayerEntitySyncHook) {
            ServerPlayerEntitySyncHook serverPlayerEntitySyncHook = (ServerPlayerEntitySyncHook)player;
            syncId = serverPlayerEntitySyncHook.fabric_incrementSyncId();
        } else if (player instanceof ServerPlayerEntityAccessor) {
            if (!this.emittedNoSyncHookWarning) {
                LOGGER.warn("ServerPlayerEntitySyncHook could not be applied - fabric-containers is using a hack!");
                this.emittedNoSyncHookWarning = true;
            }
            syncId = (((ServerPlayerEntityAccessor)player).getScreenHandlerSyncId() + 1) % 100;
            ((ServerPlayerEntityAccessor)player).setScreenHandlerSyncId(syncId);
        } else {
            throw new RuntimeException("Neither ServerPlayerEntitySyncHook nor Accessor present! This should not happen!");
        }
        PacketByteBuf buf = new PacketByteBuf(Unpooled.buffer());
        buf.writeIdentifier(identifier);
        buf.writeByte(syncId);
        writer.accept(buf);
        player.networkHandler.sendPacket((Packet)new CustomPayloadS2CPacket(OPEN_CONTAINER, buf));
        PacketByteBuf clonedBuf = new PacketByteBuf(buf.duplicate());
        clonedBuf.readIdentifier();
        clonedBuf.readUnsignedByte();
        Object screenHandler = this.createContainer(syncId, identifier, (PlayerEntity)player, clonedBuf);
        if (screenHandler == null) {
            return;
        }
        player.currentScreenHandler = screenHandler;
        ((ServerPlayerEntityAccessor)player).callOnScreenHandlerOpened((ScreenHandler)screenHandler);
    }

    public <C extends ScreenHandler> C createContainer(int syncId, Identifier identifier, PlayerEntity player, PacketByteBuf buf) {
        ContainerFactory<ScreenHandler> factory = FACTORIES.get(identifier);
        if (factory == null) {
            LOGGER.error("No container factory found for {}!", (Object)identifier.toString());
            return null;
        }
        return (C)factory.create(syncId, identifier, player, buf);
    }
}

